/*
 * Decompiled with CFR 0.152.
 */
package net.morilib.lisp;

import net.morilib.lang.number.Integer2;
import net.morilib.lang.number.Rational;
import net.morilib.lisp.LispDouble;
import net.morilib.lisp.LispExactReal;
import net.morilib.lisp.LispInteger;
import net.morilib.lisp.LispIrrational;
import net.morilib.lisp.LispNumber;
import net.morilib.lisp.LispReal;
import net.morilib.math.constants.AlternatingSeriesNumber;

public abstract class LispAlternatingSeriesNumber
extends LispIrrational {
    protected AlternatingSeriesNumber value;

    protected LispAlternatingSeriesNumber(AlternatingSeriesNumber value) {
        this.value = value;
    }

    @Override
    public int castInt() {
        return this.value.intValue();
    }

    @Override
    public long castLong() {
        return this.value.longValue();
    }

    @Override
    public Integer2 castInteger2() {
        return this.value.toInteger2();
    }

    @Override
    public int intFloor() {
        return this.castInt() - (this.value.signum() > 0 ? 0 : 1);
    }

    @Override
    public long longFloor() {
        return this.castLong() - (long)(this.value.signum() > 0 ? 0 : 1);
    }

    @Override
    public Integer2 getInteger2Floor() {
        return this.castInteger2().add(Integer2.valueOf(this.value.signum() > 0 ? 0 : -1));
    }

    @Override
    public int intCeil() {
        return this.castInt() + (this.value.signum() > 0 ? 1 : 0);
    }

    @Override
    public long longCeil() {
        return this.castLong() + (long)(this.value.signum() > 0 ? 1 : 0);
    }

    @Override
    public Integer2 getInteger2Ceil() {
        return this.castInteger2().add(Integer2.valueOf(this.value.signum() > 0 ? 1 : 0));
    }

    @Override
    public Rational getRational() {
        return Rational.valueOf(this.value.doubleValue());
    }

    @Override
    public float floatValue() {
        return this.value.floatValue();
    }

    @Override
    public double doubleValue() {
        return this.value.doubleValue();
    }

    @Override
    public LispReal invert() {
        return new LispDouble(1.0 / this.value.doubleValue());
    }

    @Override
    public Rational toRational() {
        return this.getRational();
    }

    @Override
    public boolean isLessThan(LispReal x) {
        if (this.getClass().equals(x.getClass())) {
            LispAlternatingSeriesNumber w = (LispAlternatingSeriesNumber)x;
            LispExactReal a = this.prototype(this.value.getScale().subtract(w.value.getScale()), this.value.getShift().subtract(w.value.getShift()));
            return a.signum() < 0;
        }
        if (x instanceof LispAlternatingSeriesNumber) {
            return this.value.compareTo(((LispAlternatingSeriesNumber)x).value) < 0;
        }
        if (x.isRational()) {
            return this.value.compareTo(x.getRational()) < 0;
        }
        return this.value.doubleValue() < x.doubleValue();
    }

    @Override
    public boolean isMoreThan(LispReal x) {
        if (this.getClass().equals(x.getClass())) {
            LispAlternatingSeriesNumber w = (LispAlternatingSeriesNumber)x;
            LispExactReal a = this.prototype(this.value.getScale().subtract(w.value.getScale()), this.value.getShift().subtract(w.value.getShift()));
            return a.signum() > 0;
        }
        if (x instanceof LispAlternatingSeriesNumber) {
            return this.value.compareTo(((LispAlternatingSeriesNumber)x).value) > 0;
        }
        if (x.isRational()) {
            return this.value.compareTo(x.getRational()) > 0;
        }
        return this.value.doubleValue() > x.doubleValue();
    }

    @Override
    public boolean isEqualTo(LispNumber x) {
        if (this.getClass().equals(x.getClass())) {
            return this.value.getScale().compareTo(((LispAlternatingSeriesNumber)x).value.getScale()) == 0;
        }
        if (x instanceof LispAlternatingSeriesNumber) {
            return false;
        }
        return false;
    }

    @Override
    public int signum() {
        return this.value.signum();
    }

    @Override
    public LispReal toInexact() {
        return new LispDouble(this.value.doubleValue());
    }

    @Override
    public String getResult() {
        return this.value.toString();
    }

    @Override
    public LispReal floor() {
        return LispInteger.valueOf(this.getInteger2Floor().toBigInteger());
    }

    @Override
    public LispReal ceil() {
        return LispInteger.valueOf(this.getInteger2Ceil().toBigInteger());
    }

    @Override
    public int hashCode() {
        return this.value.hashCode();
    }

    @Override
    public boolean equals(Object o) {
        return o instanceof LispAlternatingSeriesNumber && this.value.equals(((LispAlternatingSeriesNumber)o).value);
    }

    @Override
    public double getRealDouble() {
        return this.value.doubleValue();
    }

    public abstract LispExactReal prototype(Rational var1, Rational var2);

    @Override
    public LispNumber add(LispNumber x) {
        if (this.getClass().equals(x.getClass())) {
            Rational v = this.value.getScale().add(((LispAlternatingSeriesNumber)x).value.getScale());
            Rational s = this.value.getShift().add(((LispAlternatingSeriesNumber)x).value.getShift());
            return this.prototype(v, s);
        }
        if (x.isRational() && x.isExact()) {
            Rational v = this.value.getShift().add(((LispExactReal)x).toRational());
            return this.prototype(this.value.getScale(), v);
        }
        if (x instanceof LispReal) {
            return new LispDouble(this.value.doubleValue() + x.getRealDouble());
        }
        return super.add(x);
    }

    @Override
    public LispNumber sub(LispNumber x) {
        if (this.getClass().equals(x.getClass())) {
            Rational v = this.value.getScale().subtract(((LispAlternatingSeriesNumber)x).value.getScale());
            Rational s = this.value.getShift().subtract(((LispAlternatingSeriesNumber)x).value.getShift());
            return this.prototype(v, s);
        }
        if (x.isRational() && x.isExact()) {
            Rational v = this.value.getShift().subtract(((LispExactReal)x).toRational());
            return this.prototype(this.value.getScale(), v);
        }
        if (x instanceof LispReal) {
            return new LispDouble(this.value.doubleValue() - x.getRealDouble());
        }
        return super.sub(x);
    }

    @Override
    public LispNumber mul(LispNumber x) {
        if (x.isRational() && x.isExact()) {
            Rational v = this.value.getScale().multiply(((LispExactReal)x).getRational());
            Rational s = this.value.getShift().multiply(((LispExactReal)x).getRational());
            return this.prototype(v, s);
        }
        if (x instanceof LispReal) {
            return new LispDouble(this.value.doubleValue() * x.getRealDouble());
        }
        return super.mul(x);
    }

    @Override
    public LispNumber div(LispNumber x) {
        if (x.isRational() && x.isExact()) {
            Rational v = this.value.getScale().divide(((LispExactReal)x).getRational());
            Rational s = this.value.getShift().divide(((LispExactReal)x).getRational());
            return this.prototype(v, s);
        }
        if (x instanceof LispReal) {
            return new LispDouble(this.value.doubleValue() / x.getRealDouble());
        }
        return super.mul(x);
    }
}

