/*
 * Decompiled with CFR 0.152.
 */
package net.morilib.lisp;

import java.math.BigDecimal;
import java.math.BigInteger;
import net.morilib.lisp.LispComplexImpl;
import net.morilib.lisp.LispComplexInfinity;
import net.morilib.lisp.LispComplexPolar;
import net.morilib.lisp.LispDouble;
import net.morilib.lisp.LispFloat;
import net.morilib.lisp.LispInteger;
import net.morilib.lisp.LispNumber;
import net.morilib.lisp.LispOctonion;
import net.morilib.lisp.LispQuaternion;
import net.morilib.lisp.LispReal;
import net.morilib.lisp.LispString;
import net.morilib.lisp.LispUtils;
import net.morilib.lisp.math.constants.LispPi;
import net.morilib.lisp.sos.LispType;

public abstract class LispComplex
extends LispQuaternion {
    public static final LispComplex INFINITY = LispComplexInfinity.INF;

    public static LispComplex newComplex(LispReal r, LispReal i) {
        if (r.isNaN() || i.isNaN()) {
            return LispDouble.NaN;
        }
        if (i.isExact() && i.signum() == 0) {
            return r;
        }
        if (r.isExact() && i.isExact()) {
            return new LispComplexImpl(r, i);
        }
        return new LispComplexImpl(r.toInexact(), i.toInexact());
    }

    public static LispComplex newComplex(double r, double i) {
        if (Double.isNaN(r) || Double.isNaN(i)) {
            return LispDouble.NaN;
        }
        return new LispComplexImpl(new LispDouble(r), new LispDouble(i));
    }

    public static LispComplex newComplex(float r, float i) {
        if (Float.isNaN(r) || Float.isNaN(i)) {
            return LispFloat.NaN;
        }
        return new LispComplexImpl(new LispFloat(r), new LispFloat(i));
    }

    public static LispComplex newPolar(LispReal r, LispReal a) {
        LispReal PI2 = LispPi.PI.multiply(2);
        if (r.signum() < 0) {
            r = r.abs();
            a = a.add(LispPi.PI);
        } else if (r.signum() <= 0) {
            if (r.isExact() && a.isExact()) {
                return LispInteger.ZERO;
            }
            return LispDouble.ZERO;
        }
        if (r.isNaN() || a.isNaN() || a.isInfinity()) {
            return LispDouble.NaN;
        }
        if (r.isInfinity()) {
            return INFINITY;
        }
        if (a.isZero()) {
            return r;
        }
        if (LispComplex.isAngleRegular(a)) {
            return new LispComplexPolar(r, a);
        }
        if (!a.isExact()) {
            double x = Math.IEEEremainder(a.doubleValue(), Math.PI * 2);
            x = x > Math.PI ? x - Math.PI * 2 : x;
            return new LispComplexPolar(r, new LispDouble(x));
        }
        if (a.signum() > 0) {
            LispReal b = a;
            while (!LispComplex.isAngleRegular(b)) {
                b = b.subtract(PI2);
            }
            b = b.compareTo(LispPi.PI) > 0 ? b.subtract(PI2) : b;
            return new LispComplexPolar(r, b);
        }
        LispReal b = a;
        while (!LispComplex.isAngleRegular(b)) {
            b = b.add(PI2);
        }
        b = b.compareTo(LispPi.PI) > 0 ? b.subtract(PI2) : b;
        return new LispComplexPolar(r, b);
    }

    public static LispComplex newPolar(double r, double a) {
        if (Double.isNaN(r) || Double.isNaN(a) || Double.isInfinite(a)) {
            return LispDouble.NaN;
        }
        if (r == 0.0) {
            return LispDouble.ZERO;
        }
        double x = Math.IEEEremainder(a, Math.PI * 2);
        x = x > Math.PI ? x - Math.PI * 2 : x;
        return new LispComplexPolar(new LispDouble(r), new LispDouble(x));
    }

    public static LispComplex newPolar(float r, float a) {
        if (Float.isNaN(r) || Float.isNaN(a) || Float.isInfinite(a)) {
            return LispFloat.NaN;
        }
        if ((double)r == 0.0) {
            return LispFloat.ZERO;
        }
        double x = Math.IEEEremainder(a, Math.PI * 2);
        x = x > Math.PI ? x - Math.PI * 2 : x;
        return new LispComplexPolar(new LispFloat(r), new LispFloat((float)x));
    }

    private static boolean isAngleRegular(LispReal a) {
        return LispPi.PI.compareTo(a) > 0 && LispPi.PI.uminus().compareTo(a) < 0;
    }

    @Override
    public boolean isInteger() {
        return false;
    }

    @Override
    public boolean isRational() {
        return false;
    }

    @Override
    public boolean isReal() {
        return false;
    }

    @Override
    public boolean isNaN() {
        return this.getReal().isNaN() || this.getImag().isNaN();
    }

    @Override
    public boolean isOne() {
        return this.getReal().isOne() && this.getImag().isZero();
    }

    @Override
    public BigInteger getBigInteger() {
        throw new UnsupportedOperationException();
    }

    @Override
    public BigInteger getDenominator() {
        throw new UnsupportedOperationException();
    }

    @Override
    public int getInt() {
        throw new UnsupportedOperationException();
    }

    @Override
    public long getLong() {
        throw new UnsupportedOperationException();
    }

    @Override
    public BigDecimal getBigDecimal() {
        throw new UnsupportedOperationException();
    }

    @Override
    public BigInteger getNumerator() {
        throw new UnsupportedOperationException();
    }

    @Override
    public abstract LispComplex uminus();

    @Override
    public abstract LispComplex toExact();

    @Override
    public abstract LispComplex toInexact();

    @Override
    public abstract LispComplex conjugate();

    public abstract LispReal angle();

    @Override
    public LispReal[] getImags() {
        return new LispReal[]{this.getImag()};
    }

    @Override
    public double[] getImagsDouble() {
        return new double[]{this.getImagDouble()};
    }

    @Override
    public LispReal[] getImagsAsQuaternion() {
        LispReal im = this.getImag();
        LispReal o = this.isExact() ? LispInteger.ZERO : new LispDouble(0.0);
        return new LispReal[]{im, o, o};
    }

    @Override
    public double[] getImagsDoubleAsQuaternion() {
        double im = this.getImagDouble();
        return new double[]{im, 0.0, 0.0};
    }

    @Override
    public LispReal[] getImagsAsOctonion() {
        LispReal im = this.getImag();
        LispReal o = this.isExact() ? LispInteger.ZERO : new LispDouble(0.0);
        return new LispReal[]{im, o, o, o, o, o, o};
    }

    @Override
    public double[] getImagsDoubleAsOctonion() {
        double im = this.getImagDouble();
        return new double[]{im, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0};
    }

    @Override
    LispComplex getComplexPairA() {
        return this;
    }

    @Override
    LispComplex getComplexPairB() {
        return LispInteger.ZERO;
    }

    @Override
    public LispString toLispString(int radix) {
        if (radix < 2 || radix > 36) {
            throw new IndexOutOfBoundsException("radix is out of range");
        }
        if (radix != 10) {
            throw new IllegalArgumentException("radix except 10 is not supported");
        }
        if (this.getImag().signum() < 0 || this.getImag().isInfinity()) {
            return new LispString(String.valueOf(LispUtils.getResult(this.getReal())) + LispUtils.getResult(this.getImag()) + "i");
        }
        return new LispString(String.valueOf(LispUtils.getResult(this.getReal())) + "+" + LispUtils.getResult(this.getImag()) + "i");
    }

    @Override
    public LispString toLispString(int radix, int precision) {
        if (radix < 2 || radix > 36) {
            throw new IndexOutOfBoundsException("radix is out of range");
        }
        if (radix != 10) {
            throw new IllegalArgumentException("radix except 10 is not supported");
        }
        String rs = this.getReal().toLispString(radix, precision).getString();
        String is = this.getImag().toLispString(radix, precision).getString();
        if (this.getImag().signum() < 0 && !this.getImag().isInfinity()) {
            return new LispString(String.valueOf(rs) + is + "i");
        }
        return new LispString(String.valueOf(rs) + "+" + is + "i");
    }

    @Override
    public LispType getType() {
        return LispType.COMPLEX;
    }

    @Override
    public boolean isEqualTo(LispNumber x) {
        if (x instanceof LispComplex) {
            LispComplex c = (LispComplex)x;
            return this.getReal().isEqualTo(c.getReal()) && this.getImag().isEqualTo(c.getImag());
        }
        if (x instanceof LispReal) {
            return false;
        }
        return super.isEqualTo(x);
    }

    @Override
    public LispNumber add(LispNumber x) {
        if (x instanceof LispComplex) {
            LispComplex c = (LispComplex)x;
            if (x == INFINITY) {
                return INFINITY;
            }
            return LispComplex.newComplex(this.getReal().add(c.getReal()), this.getImag().add(c.getImag()));
        }
        if (x instanceof LispReal) {
            return LispComplex.newComplex(this.getReal().add(x.getReal()), this.getImag());
        }
        if (x instanceof LispQuaternion) {
            return LispQuaternion.add(this, (LispQuaternion)x);
        }
        if (x instanceof LispOctonion) {
            return LispOctonion.add(this, (LispOctonion)x);
        }
        throw new IllegalArgumentException(x.toString());
    }

    @Override
    public LispNumber sub(LispNumber x) {
        if (x instanceof LispComplex) {
            LispComplex c = (LispComplex)x;
            if (x == INFINITY) {
                return INFINITY;
            }
            return LispComplex.newComplex(this.getReal().subtract(c.getReal()), this.getImag().subtract(c.getImag()));
        }
        if (x instanceof LispReal) {
            return LispComplex.newComplex(this.getReal().subtract(x.getReal()), this.getImag());
        }
        if (x instanceof LispQuaternion) {
            return LispQuaternion.sub(this, (LispQuaternion)x);
        }
        if (x instanceof LispOctonion) {
            return LispOctonion.sub(this, (LispOctonion)x);
        }
        throw new IllegalArgumentException(x.toString());
    }

    @Override
    public LispNumber mul(LispNumber x) {
        if (x instanceof LispComplex) {
            LispReal xr = ((LispComplex)x).getReal();
            LispReal xi = ((LispComplex)x).getImag();
            if (x == INFINITY) {
                return INFINITY;
            }
            if (xr.signum() == 0) {
                return LispComplex.newComplex(this.getImag().uminus().multiply(xi), this.getReal().multiply(xi));
            }
            return LispComplex.newComplex(this.getReal().multiply(xr).subtract(this.getImag().multiply(xi)), this.getImag().multiply(xr).add(this.getReal().multiply(xi)));
        }
        if (x instanceof LispReal) {
            LispReal r = x.getReal();
            return LispComplex.newComplex(this.getReal().multiply(r), this.getImag().multiply(r));
        }
        if (x instanceof LispQuaternion) {
            return LispQuaternion.mul(this, (LispQuaternion)x);
        }
        if (x instanceof LispOctonion) {
            return LispOctonion.mul(this, (LispOctonion)x);
        }
        throw new IllegalArgumentException(x.toString());
    }

    @Override
    public LispNumber div(LispNumber x) {
        if (x instanceof LispComplex) {
            LispReal xr = ((LispComplex)x).getReal();
            LispReal xi = ((LispComplex)x).getImag();
            if (x == INFINITY) {
                return this.isExact() ? LispInteger.ZERO : LispDouble.ZERO;
            }
            if (xr.signum() == 0) {
                return LispComplex.newComplex(this.getImag().divide(xi), this.getReal().uminus().divide(xi));
            }
            LispReal nr = xr.multiply(xr).add(xi.multiply(xi));
            LispReal x1 = this.getReal().multiply(xr).add(this.getImag().multiply(xi));
            LispReal x2 = this.getImag().multiply(xr).subtract(this.getReal().multiply(xi));
            return LispComplex.newComplex(x1.divide(nr), x2.divide(nr));
        }
        if (x instanceof LispReal) {
            LispReal r = x.getReal();
            return LispComplex.newComplex(this.getReal().divide(r), this.getImag().divide(r));
        }
        if (x instanceof LispQuaternion) {
            return LispQuaternion.div(this, (LispQuaternion)x);
        }
        if (x instanceof LispOctonion) {
            return LispOctonion.div(this, (LispOctonion)x);
        }
        throw new IllegalArgumentException(x.toString());
    }
}

