/*
 * Decompiled with CFR 0.152.
 */
package net.morilib.lisp;

import net.morilib.lisp.LispComplex;
import net.morilib.lisp.LispDouble;
import net.morilib.lisp.LispMath;
import net.morilib.lisp.LispReal;
import net.morilib.lisp.LispUtils;

public final class LispComplexImpl
extends LispComplex {
    private LispReal real;
    private LispReal imag;

    LispComplexImpl(LispReal r, LispReal i) {
        this.real = r;
        this.imag = i;
    }

    @Override
    public double getRealDouble() {
        return this.real.getRealDouble();
    }

    @Override
    public LispReal getReal() {
        return this.real;
    }

    @Override
    public double getImagDouble() {
        return this.imag.getRealDouble();
    }

    @Override
    public LispReal getImag() {
        return this.imag;
    }

    @Override
    public LispComplex toExact() {
        return LispComplexImpl.newComplex(this.getReal().toExact(), this.getImag().toExact());
    }

    @Override
    public LispComplex toInexact() {
        return LispComplexImpl.newComplex(this.getReal().toInexact(), this.getImag().toInexact());
    }

    @Override
    public LispComplex conjugate() {
        return new LispComplexImpl(this.getReal(), this.getImag().uminus());
    }

    @Override
    public LispComplex uminus() {
        return new LispComplexImpl(this.getReal().uminus(), this.getImag().uminus());
    }

    @Override
    public boolean isExact() {
        return this.getReal().isExact();
    }

    @Override
    public LispReal norm() {
        return (LispReal)LispMath.sqrt((LispReal)this.getReal().mul(this.getReal()).add(this.getImag().mul(this.getImag())));
    }

    @Override
    public LispReal normSquared() {
        return (LispReal)this.getReal().mul(this.getReal()).add(this.getImag().mul(this.getImag()));
    }

    @Override
    public LispReal angle() {
        return new LispDouble(Math.atan2(this.getImagDouble(), this.getRealDouble()));
    }

    @Override
    public boolean isFinite() {
        return this.real.isFinite() && this.imag.isFinite();
    }

    public boolean equals(Object x) {
        if (x instanceof LispComplexImpl) {
            LispComplexImpl c = (LispComplexImpl)x;
            return this.real.equals(c.real) && this.imag.equals(c.imag);
        }
        return false;
    }

    public int hashCode() {
        int l = 17;
        l = 37 * (l + this.real.hashCode());
        l = 37 * (l + this.imag.hashCode());
        return l;
    }

    @Override
    public String getResult() {
        if (this.getImag().signum() < 0 || this.getImag().isInfinity()) {
            return String.valueOf(LispUtils.getResult(this.getReal())) + LispUtils.getResult(this.getImag()) + "i";
        }
        return String.valueOf(LispUtils.getResult(this.getReal())) + "+" + LispUtils.getResult(this.getImag()) + "i";
    }

    @Override
    public String print() {
        return this.getResult();
    }

    @Override
    public String toString() {
        return this.getResult();
    }
}

