/*
 * Decompiled with CFR 0.152.
 */
package net.morilib.lisp;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintStream;
import java.io.UnsupportedEncodingException;
import java.io.Writer;
import net.morilib.lisp.Datum;
import net.morilib.lisp.LispCharacter;
import net.morilib.lisp.LispIOException;
import net.morilib.lisp.LispMessage;
import net.morilib.lisp.LispUtils;
import net.morilib.lisp.r6rs.io.ILispSimpleOutputPort;
import net.morilib.lisp.r6rs.io.ILispTextualOutputPort;
import net.morilib.lisp.r6rs.io.transcd.ILispTranscoder;
import net.morilib.lisp.r6rs.io.transcd.LispBufferMode;
import net.morilib.util.io.UTF8StringBuilderOutputStream;

public class OutputPort
extends Datum
implements ILispSimpleOutputPort,
ILispTextualOutputPort {
    private PrintStream lineWriter;
    private boolean standard;
    private boolean closed = false;
    private UTF8StringBuilderOutputStream stringPort;
    private LispMessage msg;

    private OutputPort(OutputStream wr, boolean std, LispMessage msg) {
        this.lineWriter = wr instanceof PrintStream ? (PrintStream)wr : new PrintStream(wr);
        this.standard = std;
        this.msg = msg;
        this.stringPort = wr instanceof UTF8StringBuilderOutputStream ? (UTF8StringBuilderOutputStream)wr : null;
    }

    public OutputPort(PrintStream wr, LispMessage msg) {
        this(wr, false, msg);
    }

    public OutputPort(OutputStream wr, LispMessage msg) {
        this(wr, false, msg);
    }

    public OutputPort(File fname, LispMessage msg) {
        try {
            FileOutputStream wr = new FileOutputStream(fname);
            this.lineWriter = new PrintStream(wr);
            this.standard = false;
        }
        catch (FileNotFoundException e) {
            throw new LispIOException(e);
        }
    }

    public OutputPort(File fname, String encoding, LispMessage msg) throws UnsupportedEncodingException {
        try {
            FileOutputStream wr = new FileOutputStream(fname);
            this.lineWriter = new PrintStream((OutputStream)wr, true, encoding);
            this.standard = false;
        }
        catch (FileNotFoundException e) {
            throw new LispIOException(e);
        }
    }

    static OutputPort getStringPort(LispMessage msg) {
        return new OutputPort(new UTF8StringBuilderOutputStream(), false, msg);
    }

    public static OutputPort getStandard(LispMessage msg) {
        return new OutputPort(System.out, true, msg);
    }

    @Override
    public void writeChar(LispCharacter ch) {
        if (this.closed) {
            throw this.msg.getError("err.port.closed");
        }
        if (this.standard) {
            System.out.print(ch.getCharacter());
        } else {
            this.lineWriter.print(ch.getCharacter());
        }
    }

    @Override
    public void write(Datum d) {
        if (this.closed) {
            throw this.msg.getError("err.port.closed");
        }
        if (this.standard) {
            System.out.print(LispUtils.getResultWithoutSS(d));
        } else {
            this.lineWriter.print(LispUtils.getResultWithoutSS(d));
        }
    }

    @Override
    public void display(Datum d) {
        if (this.closed) {
            throw this.msg.getError("err.port.closed");
        }
        if (this.standard) {
            System.out.print(LispUtils.print(d));
        } else {
            this.lineWriter.print(LispUtils.print(d));
        }
    }

    @Override
    public void writeWithSS(Datum d) {
        if (this.closed) {
            throw this.msg.getError("err.port.closed");
        }
        if (this.standard) {
            System.out.print(LispUtils.getResult(d));
        } else {
            this.lineWriter.print(LispUtils.getResult(d));
        }
    }

    @Override
    public void newline() {
        if (this.closed) {
            throw this.msg.getError("err.port.closed");
        }
        if (this.standard) {
            System.out.println();
        } else {
            this.lineWriter.println();
        }
    }

    @Override
    public void close() {
        if (!this.closed && !this.standard) {
            this.lineWriter.close();
            this.closed = true;
        }
    }

    public boolean isStandard() {
        return this.standard;
    }

    @Override
    public boolean isTypePort() {
        return true;
    }

    public boolean isStringPort() {
        return this.stringPort != null;
    }

    @Override
    public Writer getWriter() {
        return new OutputStreamWriter(this.lineWriter);
    }

    public PrintStream getPrintStream() {
        return this.lineWriter;
    }

    public String getOutputString() {
        if (this.isStringPort()) {
            return new String(this.stringPort.toString());
        }
        throw new IllegalStateException();
    }

    @Override
    public ILispTranscoder getTranscoder() {
        return null;
    }

    @Override
    public boolean hasPortPosition() {
        return false;
    }

    @Override
    public Datum getPortPosition() {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean hasSetPortPosition() {
        return false;
    }

    @Override
    public void setPortPosition(Datum pos) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void flush() throws IOException {
        this.lineWriter.flush();
    }

    @Override
    public void putChar(int c) throws IOException {
        this.writeChar(LispCharacter.valueOf(c));
    }

    @Override
    public void putString(String s) throws IOException {
        this.lineWriter.print(s);
    }

    @Override
    public void putString(String s, int start) throws IOException {
        this.lineWriter.print(s.substring(start));
    }

    @Override
    public void putString(String s, int start, int end) throws IOException {
        this.lineWriter.print(s.substring(start, end));
    }

    @Override
    public void putDatum(Datum d) throws IOException {
        this.writeWithSS(d);
    }

    @Override
    public LispBufferMode getBufferMode() {
        return LispBufferMode.NONE;
    }

    @Override
    public void toDisplayString(StringBuilder buf) {
        buf.append("#<oport>");
    }
}

