/*
 * Decompiled with CFR 0.152.
 */
package net.morilib.lisp;

import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;
import net.morilib.lisp.Datum;
import net.morilib.lisp.Environment;
import net.morilib.lisp.LispBoolean;
import net.morilib.lisp.LispMessage;
import net.morilib.lisp.LispString;
import net.morilib.lisp.math.algebra.ILispAddable;
import net.morilib.lisp.math.algebra.ILispMultipliable;
import net.morilib.lisp.sos.LispType;
import net.morilib.lisp.subr.UnaryArgs;

public final class RegexPattern
extends Datum
implements ILispAddable<RegexPattern>,
ILispMultipliable<RegexPattern> {
    private static final Pattern REGEX_PAT = Pattern.compile("/(.*)/([iuc]*)");
    private Pattern pattern;
    private String patternString;
    private String patternString2;
    private String flags;

    public RegexPattern(String regex, String fl) {
        int flg = 0;
        int i = 0;
        while (i < fl.length()) {
            switch (fl.charAt(i)) {
                case 'u': {
                    flg |= 0x40;
                    break;
                }
                case 'i': {
                    flg |= 2;
                    break;
                }
                case 'c': {
                    flg |= 0x80;
                    break;
                }
                default: {
                    throw new IllegalArgumentException(fl);
                }
            }
            ++i;
        }
        this.pattern = Pattern.compile(regex, flg);
        this.patternString = "#/" + regex + "/" + fl;
        this.patternString2 = regex;
        this.flags = fl;
    }

    public Datum getMatch(String str) {
        Matcher mt = this.pattern.matcher(str);
        return mt.matches() ? new Match(mt) : LispBoolean.FALSE;
    }

    public Pattern getPattern() {
        return this.pattern;
    }

    public String getPatternString() {
        return this.patternString;
    }

    public String getPatternString2() {
        return this.patternString2;
    }

    public boolean matches(CharSequence s) {
        return this.pattern.matcher(s).matches();
    }

    @Override
    public RegexPattern mul(RegexPattern y) {
        return new RegexPattern("(" + this.patternString2 + y.patternString2 + ")", this.flags);
    }

    @Override
    public RegexPattern add(RegexPattern y) {
        return new RegexPattern("(" + this.patternString2 + "|" + y.patternString2 + ")", this.flags);
    }

    @Override
    public LispType getType() {
        return LispType.REGEXP;
    }

    @Override
    public void toDisplayString(StringBuilder buf) {
        buf.append("#<regexp " + this.getPatternString() + ">");
    }

    public static final class CompileRe
    extends UnaryArgs {
        @Override
        protected Datum execute(Datum c1a, Environment env, LispMessage mesg) {
            if (c1a instanceof LispString) {
                String tok = ((LispString)c1a).getString();
                Matcher mch = REGEX_PAT.matcher(tok);
                if (!mch.matches()) {
                    throw mesg.getError("err.regex.syntax", tok);
                }
                String re = mch.group(1);
                String fl = mch.group(2);
                try {
                    return new RegexPattern(re, fl);
                }
                catch (PatternSyntaxException e) {
                    throw mesg.getError("err.regex.syntax", tok);
                }
            }
            throw mesg.getError("err.require.string", c1a);
        }
    }

    public static class Match
    extends Datum {
        private Matcher match;

        private Match(Matcher x) {
            this.match = x;
        }

        public Datum group() {
            return new LispString(this.match.group());
        }

        public Datum group(int no) {
            String res = this.match.group(no);
            return res != null ? new LispString(res) : null;
        }

        public String toStringRepl() {
            return this.match.toString();
        }

        @Override
        public void toDisplayString(StringBuilder buf) {
            buf.append("#<rxmatch " + this.toStringRepl() + ">");
        }
    }
}

