/*
 * Decompiled with CFR 0.152.
 */
package net.morilib.lisp;

import java.nio.ByteOrder;
import java.util.Iterator;
import java.util.List;
import net.morilib.lisp.CodeExecutor;
import net.morilib.lisp.CompiledCode;
import net.morilib.lisp.Cons;
import net.morilib.lisp.ConsIterator;
import net.morilib.lisp.Datum;
import net.morilib.lisp.Datum2;
import net.morilib.lisp.Environment;
import net.morilib.lisp.IntStack;
import net.morilib.lisp.LispCompiler;
import net.morilib.lisp.LispMessage;
import net.morilib.lisp.Syntax;
import net.morilib.lisp.subr.SubrUtils;

public class SRFI74Endianness
extends Syntax {
    public static final Datum BIG_ENDIAN = new Endian(ByteOrder.BIG_ENDIAN);
    public static final Datum LITTLE_ENDIAN = new Endian(ByteOrder.LITTLE_ENDIAN);

    public static final Datum getNative() {
        return ByteOrder.BIG_ENDIAN.equals(ByteOrder.nativeOrder()) ? BIG_ENDIAN : LITTLE_ENDIAN;
    }

    @Override
    void compile(Datum body, Environment env, LispCompiler comp, CompiledCode.Builder build, boolean toplevel, Cons callsym, boolean istail, LispMessage mesg, List<Cons> symlist, CodeExecutor exec, IntStack memento, LispCompiler.MiscInfo syncased) {
        ConsIterator itr = new ConsIterator(body);
        String s = SubrUtils.nextSymbolName((Iterator<Datum>)itr, mesg, body);
        SubrUtils.checkTerminated(itr, body, mesg);
        if (s.equals("big")) {
            build.addPush(BIG_ENDIAN);
        } else if (s.equals("little")) {
            build.addPush(LITTLE_ENDIAN);
        } else if (s.equals("native")) {
            build.addPush(SRFI74Endianness.getNative());
        } else {
            throw mesg.getError("err.srfi74.endianness.invalid", s);
        }
    }

    @Override
    Datum replaceLocalVals(Datum body, Environment env, LispCompiler comp, Environment ienv, LispMessage mesg, boolean toplv, int ttype) {
        return body;
    }

    public static class Endian
    extends Datum2 {
        private ByteOrder bo;

        private Endian(ByteOrder bo) {
            this.bo = bo;
        }

        public ByteOrder getByteOrder() {
            return this.bo;
        }

        @Override
        public void toDisplayString(StringBuilder buf) {
            if (this.bo.equals(ByteOrder.BIG_ENDIAN)) {
                buf.append("#<endianness big>");
            } else {
                buf.append("#<endianness little>");
            }
        }
    }
}

