/*
 * Decompiled with CFR 0.152.
 */
package net.morilib.lisp;

import java.util.HashMap;
import java.util.Map;
import net.morilib.lisp.ClosureClass;
import net.morilib.lisp.Datum;
import net.morilib.lisp.Environment;
import net.morilib.lisp.ISubr;
import net.morilib.lisp.LispMessage;
import net.morilib.lisp.LispUtils;
import net.morilib.lisp.Procedure;
import net.morilib.lisp.Settable;

public abstract class Subr
extends Settable
implements ISubr,
Procedure {
    private Map<Environment, ClosureClass> code = new HashMap<Environment, ClosureClass>();
    protected String symbolName;

    public String getSymbolName() {
        return this.symbolName;
    }

    public Subr() {
    }

    public Subr(String name) {
        this.symbolName = name;
    }

    @Override
    public abstract Datum eval(Datum var1, Environment var2, LispMessage var3);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    final ClosureClass getClosureClass(Environment env) {
        ClosureClass cl1;
        Subr subr = this;
        synchronized (subr) {
            if (!this.code.containsKey(env)) {
                cl1 = this.createClosureClass(env);
                this.code.put(env, cl1);
            } else {
                cl1 = this.code.get(env);
            }
        }
        return cl1;
    }

    ClosureClass createClosureClass(Environment env) {
        return null;
    }

    public Procedure mul(Procedure y) {
        return LispUtils.mul(this, y);
    }

    @Override
    public boolean isTypeProcedure() {
        return true;
    }

    @Override
    public String toString() {
        return "Subr:" + this.symbolName;
    }

    public boolean equals(Object o) {
        if (o instanceof Subr) {
            return this.getClass().equals(o.getClass());
        }
        return false;
    }

    public int hashCode() {
        return this.getClass().hashCode();
    }

    @Override
    public String display() {
        return "#<subr " + this.printName() + ">";
    }

    @Override
    public void toDisplayString(StringBuilder buf) {
        buf.append("#<subr " + this.getSymbolName() + ">");
    }
}

