/*
 * Decompiled with CFR 0.152.
 */
package net.morilib.lisp;

import java.util.ArrayList;
import java.util.List;
import net.morilib.lisp.CodeExecutor;
import net.morilib.lisp.CompiledCode;
import net.morilib.lisp.Cons;
import net.morilib.lisp.Datum;
import net.morilib.lisp.Environment;
import net.morilib.lisp.IntStack;
import net.morilib.lisp.LispCompiler;
import net.morilib.lisp.LispMessage;
import net.morilib.lisp.LispUtils;
import net.morilib.lisp.Nil;
import net.morilib.lisp.Symbol;
import net.morilib.lisp.Syntax;
import net.morilib.lisp.SyntaxUtils;
import net.morilib.lisp.Undef;

public class SynCond
extends Syntax {
    private static final Symbol ELSE_SYM = Symbol.getSymbol("else");
    private static final Symbol THIRD_SYM = Symbol.getSymbol("=>");

    private boolean isElseScope(Datum d) {
        return SyntaxUtils.equalsReserved(ELSE_SYM, d);
    }

    private boolean isThirdScope(Datum d) {
        return SyntaxUtils.equalsReserved(THIRD_SYM, d);
    }

    private Datum isThirdForm(Cons d2, LispMessage mesg) {
        Cons d3;
        if (d2.getCdr() instanceof Cons && this.isThirdScope((d3 = (Cons)d2.getCdr()).getCar())) {
            Cons d4;
            if (d3.getCdr() instanceof Cons && (d4 = (Cons)d3.getCdr()).getCdr() == Nil.NIL) {
                return d4.getCar();
            }
            throw mesg.getError("err.cond.malform");
        }
        return null;
    }

    @Override
    void compile(Datum body, Environment env, LispCompiler comp, CompiledCode.Builder build, boolean toplevel, Cons callsym, boolean istail, LispMessage mesg, List<Cons> symlist, CodeExecutor exec, IntStack memento, LispCompiler.MiscInfo syncased) {
        block11: {
            Datum d = body;
            int last = build.allocLabel();
            boolean notelse = true;
            while (true) {
                if (d == Nil.NIL) {
                    if (notelse) {
                        build.addPush(Undef.UNDEF);
                        build.setCurrentAddressToLabel(last);
                    }
                    break block11;
                }
                if (!notelse) {
                    throw mesg.getError("err.else");
                }
                if (!(d instanceof Cons)) break;
                Datum d1 = ((Cons)d).getCar();
                if (!(d1 instanceof Cons)) {
                    throw mesg.getError("err.cond.malform", d1);
                }
                Cons d2 = (Cons)d1;
                if (this.isElseScope(d2.getCar())) {
                    SyntaxUtils.compileList(d2.getCdr(), env, comp, build, callsym, istail, mesg, symlist, exec, memento, syncased);
                    build.setCurrentAddressToLabel(last);
                    notelse = false;
                } else {
                    int l1 = build.allocLabel();
                    comp.compile(d2.getCar(), env, build, callsym, false, symlist, exec, memento, syncased);
                    if (d2.getCdr() == Nil.NIL) {
                        build.addJmpIf(last);
                        build.addPop();
                    } else {
                        Datum d4 = this.isThirdForm(d2, mesg);
                        if (d4 != null) {
                            build.addJmpUnless(l1);
                            build.addBeginList();
                            build.addAppendList();
                            comp.compile(d4, env, build, callsym, istail, symlist, exec, memento, syncased);
                            build.addEndList();
                            build.addCall();
                            build.addJmp(last);
                            build.setCurrentAddressToLabel(l1);
                            build.addPop();
                        } else {
                            build.addJmpUnless(l1);
                            build.addPop();
                            SyntaxUtils.compileList(d2.getCdr(), env, comp, build, callsym, istail, mesg, symlist, exec, memento, syncased);
                            build.addJmp(last);
                            build.setCurrentAddressToLabel(l1);
                            build.addPop();
                        }
                    }
                }
                d = ((Cons)d).getCdr();
            }
            throw mesg.getError("err.cond.improper");
        }
    }

    @Override
    Datum replaceLocalVals(Datum body, Environment env, LispCompiler comp, Environment ienv, LispMessage mesg, boolean toplv, int ttype) {
        Datum d = body;
        ArrayList<Cons> lst = new ArrayList<Cons>();
        while (d != Nil.NIL) {
            if (d instanceof Cons) {
                Cons rc;
                Datum d1 = ((Cons)d).getCar();
                if (!(d1 instanceof Cons)) {
                    throw mesg.getError("err.cond.malform", d1);
                }
                Cons d2 = (Cons)d1;
                if (this.isElseScope(d2.getCar())) {
                    rc = new Cons();
                    rc.setCar(ELSE_SYM);
                    rc.setCdr(SyntaxUtils.replaceLocalValsList(d2.getCdr(), env, comp, ienv, mesg, toplv, ttype));
                    lst.add(rc);
                    break;
                }
                rc = new Cons();
                rc.setCar(comp.replaceLocalVals(d2.getCar(), env, ienv, false, ttype));
                Datum d4 = this.isThirdForm(d2, mesg);
                if (d4 != null) {
                    Cons rc2 = new Cons();
                    Datum lx = comp.replaceLocalVals(d4, env, ienv, false, ttype);
                    rc2.setCar(THIRD_SYM);
                    rc2.setCdr(new Cons(lx, Nil.NIL));
                    rc.setCdr(rc2);
                } else {
                    rc.setCdr(SyntaxUtils.replaceLocalValsList(d2.getCdr(), env, comp, ienv, mesg, toplv, ttype));
                }
                lst.add(rc);
                d = ((Cons)d).getCdr();
                continue;
            }
            throw mesg.getError("err.cond.improper");
        }
        return LispUtils.listToCons(lst);
    }
}

