/*
 * Decompiled with CFR 0.152.
 */
package net.morilib.lisp.array;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Iterator;
import net.morilib.lisp.ConsIterator;
import net.morilib.lisp.Datum;
import net.morilib.lisp.Datum2;
import net.morilib.lisp.Environment;
import net.morilib.lisp.LispInteger;
import net.morilib.lisp.LispMessage;
import net.morilib.lisp.LispReal;
import net.morilib.lisp.LispVector;
import net.morilib.lisp.Subr;
import net.morilib.lisp.array.ILispArray;
import net.morilib.lisp.array.LispArrayPrototype;
import net.morilib.lisp.array.LispArrayShape;
import net.morilib.lisp.array.LispDefaultArray;
import net.morilib.lisp.array.SRFI47Array;
import net.morilib.lisp.array.ValueOutOfBoundsException;
import net.morilib.lisp.subr.SubrUtils;
import net.morilib.util.Bytes;
import net.morilib.util.Iterators;

public class LispArrayU16
extends SRFI47Array
implements Serializable {
    private short[] real;

    public LispArrayU16(short r, int ... is) {
        super(is);
        this.real = new short[LispArrayShape.arraylength(is)];
        Arrays.fill(this.real, r);
    }

    @Override
    public int rank() {
        return this.eIndices.length;
    }

    @Override
    public int startIndex(int dim) {
        if (dim < 0 || dim >= this.eIndices.length) {
            throw new IndexOutOfBoundsException();
        }
        return 0;
    }

    @Override
    public int endIndex(int dim) {
        return this.eIndices[dim];
    }

    @Override
    public LispVector toVector() {
        Datum[] r = new Datum[LispArrayShape.arraylength(this.eIndices)];
        int i = 0;
        while (i < r.length) {
            r[i] = LispInteger.valueOf(Bytes.ushortToInt(this.real[i]));
            ++i;
        }
        return new LispVector(r);
    }

    @Override
    public Datum getFromArray(int ... is) {
        return LispInteger.valueOf(Bytes.ushortToInt(this.real[LispArrayShape.arrayindex(this.eIndices, is)]));
    }

    @Override
    public void setToArray(Datum d, int ... is) {
        if (!(d instanceof LispReal)) {
            throw new ClassCastException();
        }
        if (!((LispReal)d).inUnsignedShortRange()) {
            throw new ValueOutOfBoundsException(d.toString());
        }
        this.real[LispArrayShape.arrayindex((int[])this.eIndices, (int[])is)] = (short)d.getInt();
    }

    @Override
    public boolean isEqualTo(ILispArray a) {
        if (!this.isIndexEqualTo(a)) {
            return false;
        }
        if (a instanceof LispArrayU16) {
            return Arrays.equals(this.real, ((LispArrayU16)a).real);
        }
        return LispDefaultArray.isEqualTo(this, a);
    }

    @Override
    public String getTypeSpecifier() {
        return "fixN16b";
    }

    @Override
    public void fill(Iterator<Datum> itr) {
        int i = 0;
        while (i < this.real.length && itr.hasNext()) {
            Datum x = itr.next();
            if (!(x instanceof LispReal)) {
                throw new ClassCastException();
            }
            if (!((LispReal)x).inUnsignedShortRange()) {
                throw new ValueOutOfBoundsException(x.toString());
            }
            this.real[i] = (short)x.getInt();
            ++i;
        }
    }

    public static class Au16
    extends Subr {
        @Override
        public Datum eval(Datum body, Environment env, LispMessage mesg) {
            ConsIterator itr = new ConsIterator(body);
            Datum d = Iterators.nextIf(itr);
            SubrUtils.checkTerminated(itr, body, mesg);
            if (d == null || d instanceof LispReal) {
                return new Prototype(d == null ? (short)0 : (short)d.getInt());
            }
            throw mesg.getError("err.require.real", d);
        }
    }

    public static class Prototype
    extends Datum2
    implements LispArrayPrototype {
        private short real;

        public Prototype(short real) {
            this.real = real;
        }

        @Override
        public ILispArray makeArray(int ... is) {
            return new LispArrayU16(this.real, is);
        }

        @Override
        public void toDisplayString(StringBuilder buf) {
            buf.append("#<au16 prototype>");
        }
    }
}

