/*
 * Decompiled with CFR 0.152.
 */
package net.morilib.lisp.array;

import java.io.Serializable;
import java.lang.reflect.Array;
import java.util.Arrays;
import java.util.Iterator;
import net.morilib.lisp.ConsIterator;
import net.morilib.lisp.Datum;
import net.morilib.lisp.Datum2;
import net.morilib.lisp.Environment;
import net.morilib.lisp.LispMessage;
import net.morilib.lisp.LispUtils;
import net.morilib.lisp.LispVector;
import net.morilib.lisp.Subr;
import net.morilib.lisp.Undef;
import net.morilib.lisp.array.ILispArray;
import net.morilib.lisp.array.InvalidDimensionException;
import net.morilib.lisp.array.LispArrayPrototype;
import net.morilib.lisp.array.LispArrayShape;
import net.morilib.lisp.array.LispRank0Array;
import net.morilib.lisp.array.SRFI25Array;
import net.morilib.lisp.subr.SubrUtils;
import net.morilib.util.Iterators;

public class LispDefaultArray
extends SRFI25Array
implements Serializable {
    private LispArrayShape shape;
    private Object array;

    private LispDefaultArray(LispArrayShape d, Object array) {
        this.shape = d;
        this.array = array;
    }

    public static SRFI25Array malloc(LispArrayShape d, Datum o) {
        int[] is = new int[d.rank()];
        if (d.rank() == 0) {
            return new LispRank0Array(o);
        }
        int i = 0;
        while (i < is.length) {
            is[i] = d.getEndIndex(i) - d.getStartIndex(i);
            ++i;
        }
        LispDefaultArray r = new LispDefaultArray(d, Array.newInstance(Datum.class, is));
        r.clear(o);
        return r;
    }

    public static SRFI25Array malloc(int[] bi, int[] ei, Datum o) {
        return LispDefaultArray.malloc(new LispArrayShape(bi, ei), o);
    }

    public static SRFI25Array malloc(int[] ei, Datum o) {
        int[] bi = new int[ei.length];
        Arrays.fill(bi, 0);
        return LispDefaultArray.malloc(new LispArrayShape(bi, ei), o);
    }

    @Override
    public void fill(Iterator<Datum> itr) {
        int[] is = new int[this.shape.rank()];
        Arrays.fill(is, 0);
        block0: while (itr.hasNext()) {
            Object a2 = this.array;
            Datum d = itr.next();
            int i = 0;
            while (i < is.length - 1) {
                a2 = Array.get(a2, is[i]);
                ++i;
            }
            Array.set(a2, is[is.length - 1], d);
            i = is.length - 1;
            while (i >= 0) {
                int n = i;
                is[n] = is[n] + 1;
                if (is[i] + this.shape.getStartIndex(i) < this.shape.getEndIndex(i)) continue block0;
                if (i == 0) {
                    return;
                }
                is[i] = 0;
                --i;
            }
        }
    }

    /*
     * Unable to fully structure code
     */
    public static boolean isEqualTo(ILispArray a, ILispArray b) {
        if (!a.isIndexEqualTo(b)) {
            return false;
        }
        is = new int[a.rank()];
        i = 0;
        while (i < a.rank()) {
            is[i] = a.startIndex(i);
            ++i;
        }
        block1: while (true) {
            if (!LispUtils.equals(a.getFromArray(is), b.getFromArray(is))) {
                return false;
            }
            i = is.length - 1;
            while (true) {
                if (i < 0) continue block1;
                v0 = i;
                is[v0] = is[v0] + 1;
                if (is[i] >= a.endIndex(i)) ** break;
                continue block1;
                if (i == 0) {
                    return true;
                }
                is[i] = a.startIndex(i);
                --i;
            }
            break;
        }
    }

    @Override
    public int rank() {
        return this.shape.rank();
    }

    @Override
    public int startIndex(int dim) {
        return this.shape.getStartIndex(dim);
    }

    @Override
    public int endIndex(int dim) {
        return this.shape.getEndIndex(dim);
    }

    /*
     * Unable to fully structure code
     */
    @Override
    public LispVector toVector() {
        is = new int[this.shape.rank()];
        rl = new Datum[this.shape.length()];
        n = 0;
        Arrays.fill(is, 0);
        block0: while (true) {
            a2 = this.array;
            i = 0;
            while (i < is.length - 1) {
                a2 = Array.get(a2, is[i]);
                ++i;
            }
            rl[n++] = (Datum)Array.get(a2, is[is.length - 1]);
            i = is.length - 1;
            while (true) {
                if (i < 0) continue block0;
                v0 = i;
                is[v0] = is[v0] + 1;
                if (is[i] + this.shape.getStartIndex(i) >= this.shape.getEndIndex(i)) ** break;
                continue block0;
                if (i == 0) break block0;
                is[i] = 0;
                --i;
            }
            break;
        }
        return new LispVector(rl);
    }

    /*
     * Unable to fully structure code
     */
    @Override
    public Datum getFromArray(int ... is) {
        a2 = this.array;
        i = 0;
        if (is.length == this.rank()) ** GOTO lbl7
        throw new InvalidDimensionException();
lbl-1000:
        // 1 sources

        {
            a2 = Array.get(a2, is[i] - this.shape.getStartIndex(i));
            ++i;
lbl7:
            // 2 sources

            ** while (i < is.length - 1)
        }
lbl8:
        // 1 sources

        return (Datum)Array.get(a2, is[i] - this.shape.getStartIndex(i));
    }

    /*
     * Unable to fully structure code
     */
    @Override
    public void setToArray(Datum d, int ... is) {
        a2 = this.array;
        i = 0;
        if (is.length == this.rank()) ** GOTO lbl7
        throw new InvalidDimensionException();
lbl-1000:
        // 1 sources

        {
            a2 = Array.get(a2, is[i] - this.shape.getStartIndex(i));
            ++i;
lbl7:
            // 2 sources

            ** while (i < is.length - 1)
        }
lbl8:
        // 1 sources

        Array.set(a2, is[i] - this.shape.getStartIndex(i), d);
    }

    /*
     * Unable to fully structure code
     */
    public void clear(Datum o) {
        is = new int[this.shape.rank()];
        Arrays.fill(is, 0);
        block0: while (true) {
            a2 = this.array;
            i = 0;
            while (i < is.length - 1) {
                a2 = Array.get(a2, is[i]);
                ++i;
            }
            Array.set(a2, is[is.length - 1], o);
            i = is.length - 1;
            while (true) {
                if (i < 0) continue block0;
                v0 = i;
                is[v0] = is[v0] + 1;
                if (is[i] + this.shape.getStartIndex(i) >= this.shape.getEndIndex(i)) ** break;
                continue block0;
                if (i == 0) break block0;
                is[i] = 0;
                --i;
            }
            break;
        }
    }

    @Override
    public boolean isIndexEqualTo(ILispArray a) {
        if (this.rank() != a.rank()) {
            return false;
        }
        int i = 0;
        while (i < this.rank()) {
            if (this.startIndex(i) != a.startIndex(i)) {
                return false;
            }
            if (this.endIndex(i) != a.endIndex(i)) {
                return false;
            }
            ++i;
        }
        return true;
    }

    @Override
    public boolean isEqualTo(ILispArray a) {
        return LispDefaultArray.isEqualTo(this, a);
    }

    @Override
    public String getTypeSpecifier() {
        return null;
    }

    @Override
    public LispArrayShape getShape() {
        return this.shape;
    }

    public static class DefProto
    extends Subr {
        @Override
        public Datum eval(Datum body, Environment env, LispMessage mesg) {
            ConsIterator itr = new ConsIterator(body);
            Datum d = Iterators.nextIf(itr);
            SubrUtils.checkTerminated(itr, body, mesg);
            return new Prototype(d == null ? Undef.UNDEF : d);
        }
    }

    public static class Prototype
    extends Datum2
    implements LispArrayPrototype {
        private Datum datum;

        public Prototype(Datum datum) {
            this.datum = datum;
        }

        @Override
        public ILispArray makeArray(int ... is) {
            return LispDefaultArray.malloc(is, this.datum);
        }

        @Override
        public void toDisplayString(StringBuilder buf) {
            buf.append("#<default prototype>");
        }
    }
}

