/*
 * Decompiled with CFR 0.152.
 */
package net.morilib.lisp.array;

import java.util.Arrays;
import net.morilib.lisp.Cons;
import net.morilib.lisp.ConsIterator;
import net.morilib.lisp.Datum;
import net.morilib.lisp.Environment;
import net.morilib.lisp.LispMessage;
import net.morilib.lisp.LispUtils;
import net.morilib.lisp.array.ILispArray;
import net.morilib.lisp.array.InvalidDimensionException;
import net.morilib.lisp.array.LispArrayPrototype;
import net.morilib.lisp.array.ValueOutOfBoundsException;
import net.morilib.lisp.subr.SubrUtils;
import net.morilib.lisp.subr.TernaryArgs;
import net.morilib.util.primitive.IntegerArrayVector;
import net.morilib.util.primitive.IntegerVector;

public class ListToArray
extends TernaryArgs {
    private static void setListToArray(ILispArray a, Datum d, int i, int[] is) {
        if (i < a.rank()) {
            if (!(d instanceof Cons)) {
                throw new InvalidDimensionException();
            }
            ConsIterator itr = new ConsIterator(d);
            while (itr.hasNext()) {
                ListToArray.setListToArray(a, itr.next(), i + 1, is);
                int n = i;
                is[n] = is[n] + 1;
            }
            is[i] = 0;
        } else {
            a.setToArray(d, is);
        }
    }

    private static void getdimensions(Datum p, Datum d, int dp, IntegerVector iz, LispMessage mesg) {
        if (d instanceof Cons) {
            int l = (int)LispUtils.length(d);
            if (l < 0) {
                throw mesg.getError("err.list.circulated", p);
            }
            if (dp >= iz.size()) {
                iz.add(l);
            } else if (iz.getInt(dp) != l) {
                throw mesg.getError("err.srfi58.list.invalid", p);
            }
            ConsIterator itr = new ConsIterator(d);
            while (itr.hasNext()) {
                ListToArray.getdimensions(p, itr.next(), dp + 1, iz, mesg);
            }
        }
    }

    static int[] getDimensions(Datum p, LispMessage mesg) {
        IntegerArrayVector iz = new IntegerArrayVector();
        ListToArray.getdimensions(p, p, 0, iz, mesg);
        return iz.toIntArray();
    }

    public static ILispArray setListToArray(ILispArray a, Datum d) {
        int[] x = new int[a.rank()];
        Arrays.fill(x, 0);
        ListToArray.setListToArray(a, d, 0, x);
        return a;
    }

    @Override
    protected Datum execute(Datum c1a, Datum c2a, Datum c3a, Environment env, LispMessage mesg) {
        int rank = SubrUtils.getSmallInt(c1a, mesg);
        if (c2a instanceof LispArrayPrototype) {
            int[] is = ListToArray.getDimensions(c3a, mesg);
            if (is.length != rank) {
                throw mesg.getError("err.srfi58.notation.mismatch.rank", "" + rank);
            }
            try {
                ILispArray a = ((LispArrayPrototype)((Object)c2a)).makeArray(is);
                ListToArray.setListToArray(a, c3a);
                return (Datum)((Object)a);
            }
            catch (InvalidDimensionException e) {
                throw mesg.getError("err.srfi25.dimension.invalid");
            }
            catch (IndexOutOfBoundsException e) {
                throw mesg.getError("err.range.invalid");
            }
            catch (ClassCastException e) {
                throw mesg.getError("err.srfi25.typemismatch");
            }
            catch (ValueOutOfBoundsException e) {
                throw mesg.getError("err.srfi47.valueoutofrange", e.getMessage());
            }
        }
        throw mesg.getError("err.srfi47.require.prototype", c2a);
    }
}

