/*
 * Decompiled with CFR 0.152.
 */
package net.morilib.lisp.awt.robot;

import java.awt.AWTException;
import java.awt.Image;
import java.awt.Rectangle;
import java.awt.Robot;
import java.awt.image.BufferedImage;
import java.util.Iterator;
import net.morilib.lisp.ConsIterator;
import net.morilib.lisp.Datum;
import net.morilib.lisp.Datum2;
import net.morilib.lisp.Environment;
import net.morilib.lisp.LispMessage;
import net.morilib.lisp.Subr;
import net.morilib.lisp.awt.robot.LispRobot;
import net.morilib.lisp.painter.ILispImage;
import net.morilib.lisp.subr.SubrUtils;

public class CaptureScreen
extends Subr {
    @Override
    public Datum eval(Datum body, Environment env, LispMessage mesg) {
        Datum r1;
        Robot rb;
        ConsIterator itr = new ConsIterator(body);
        Datum d1 = SubrUtils.nextIf((Iterator<Datum>)itr, mesg, body);
        if (d1 instanceof LispRobot) {
            rb = ((LispRobot)d1).robot;
            r1 = SubrUtils.nextIf((Iterator<Datum>)itr, mesg, body);
        } else {
            try {
                rb = new Robot();
                r1 = d1;
            }
            catch (AWTException e) {
                throw mesg.getError("err.awt.robot.notavailable");
            }
        }
        int rx = SubrUtils.getSmallInt(r1, mesg);
        int ry = SubrUtils.nextSmallInt((Iterator<Datum>)itr, mesg, body);
        int rw = SubrUtils.nextSmallInt((Iterator<Datum>)itr, mesg, body);
        int rh = SubrUtils.nextSmallInt((Iterator<Datum>)itr, mesg, body);
        if (rx < 0) {
            throw mesg.getError("err.require.int.nonnegative", String.valueOf(rx));
        }
        if (ry < 0) {
            throw mesg.getError("err.require.int.nonnegative", String.valueOf(ry));
        }
        if (rw <= 0) {
            throw mesg.getError("err.require.int.nonnegative", String.valueOf(rw));
        }
        if (rh <= 0) {
            throw mesg.getError("err.require.int.nonnegative", String.valueOf(rh));
        }
        final BufferedImage im = rb.createScreenCapture(new Rectangle(rx, ry, rw, rh));
        Img li = new Img(){

            @Override
            public Image getImage() {
                return im;
            }
        };
        return li;
    }

    private static abstract class Img
    extends Datum2
    implements ILispImage {
        private Img() {
        }

        @Override
        public void toDisplayString(StringBuilder buf) {
            buf.append("#<captured-image>");
        }
    }
}

