/*
 * Decompiled with CFR 0.152.
 */
package net.morilib.lisp.awt.tray;

import java.awt.TrayIcon;
import java.util.Iterator;
import net.morilib.lisp.ConsIterator;
import net.morilib.lisp.Datum;
import net.morilib.lisp.Environment;
import net.morilib.lisp.LispBoolean;
import net.morilib.lisp.LispMessage;
import net.morilib.lisp.Subr;
import net.morilib.lisp.Symbol;
import net.morilib.lisp.Undef;
import net.morilib.lisp.awt.tray.LispTrayIcon;
import net.morilib.lisp.subr.SubrUtils;
import net.morilib.util.Iterators;

public class DisplayTrayIconMessage
extends Subr {
    private static final Symbol ERROR = Symbol.getSymbol("error");
    private static final Symbol INFO = Symbol.getSymbol("info");
    private static final Symbol NONE = Symbol.getSymbol("none");
    private static final Symbol WARNING = Symbol.getSymbol("warning");

    @Override
    public Datum eval(Datum body, Environment env, LispMessage mesg) {
        ConsIterator itr = new ConsIterator(body);
        Datum io = SubrUtils.nextIf((Iterator<Datum>)itr, mesg, body);
        String tt = SubrUtils.nextString((Iterator<Datum>)itr, mesg, body);
        String mg = SubrUtils.nextString((Iterator<Datum>)itr, mesg, body);
        Datum zz = Iterators.nextIf(itr, LispBoolean.FALSE);
        if (!(io instanceof LispTrayIcon)) {
            throw mesg.getError("err.awt.require.trayicon", io);
        }
        TrayIcon ti = ((LispTrayIcon)io).icon;
        if (zz.equals(ERROR)) {
            ti.displayMessage(tt, mg, TrayIcon.MessageType.ERROR);
        } else if (zz.equals(NONE)) {
            ti.displayMessage(tt, mg, TrayIcon.MessageType.NONE);
        } else if (zz.equals(WARNING)) {
            ti.displayMessage(tt, mg, TrayIcon.MessageType.WARNING);
        } else if (zz.equals(INFO)) {
            ti.displayMessage(tt, mg, TrayIcon.MessageType.INFO);
        } else {
            ti.displayMessage(tt, mg, TrayIcon.MessageType.INFO);
        }
        return Undef.UNDEF;
    }
}

