/*
 * Decompiled with CFR 0.152.
 */
package net.morilib.lisp.collection;

import java.util.Iterator;
import net.morilib.lisp.ConsIterator;
import net.morilib.lisp.Datum;
import net.morilib.lisp.Environment;
import net.morilib.lisp.LispBoolean;
import net.morilib.lisp.LispInteger;
import net.morilib.lisp.LispMessage;
import net.morilib.lisp.LispUtils;
import net.morilib.lisp.MultiValues;
import net.morilib.lisp.Procedure;
import net.morilib.lisp.SExpressionDatum;
import net.morilib.lisp.Scheme;
import net.morilib.lisp.Subr;
import net.morilib.lisp.collection.ImmutableException;
import net.morilib.lisp.collection.LispBag;
import net.morilib.lisp.collection.LispCollection;
import net.morilib.lisp.collection.LispEntryEnumeration;
import net.morilib.lisp.subr.BinaryArgs;
import net.morilib.lisp.subr.SubrUtils;
import net.morilib.lisp.subr.UnaryArgs;
import net.morilib.util.Iterators;

public interface LispDictionary
extends LispCollection,
LispEntryEnumeration {
    public Procedure keyEquivalence();

    public boolean equivalenceKey(Datum var1, Datum var2);

    public Procedure valueEquivalence();

    public boolean equivalenceValue(Datum var1, Datum var2);

    public SExpressionDatum getAllAsList(Datum var1);

    public boolean containsKey(Datum var1);

    public SExpressionDatum keysToList();

    public Datum get(Datum var1);

    public Datum[] copyPut(Datum var1, Datum var2);

    public Datum[] put(Datum var1, Datum var2) throws ImmutableException;

    public Datum copyUpdateAll(Datum var1, Procedure var2, Procedure var3, Environment var4, LispMessage var5);

    public Datum updateAll(Datum var1, Procedure var2, Procedure var3, Environment var4, LispMessage var5) throws ImmutableException;

    public Datum copyDeleteKey(Datum var1);

    public Datum deleteKey(Datum var1) throws ImmutableException;

    public Datum copyDeleteAllKey(Datum var1);

    public Datum deleteAllKey(Datum var1) throws ImmutableException;

    public Datum copyDeleteFromKey(LispBag var1);

    public Datum deleteFromKey(LispBag var1) throws ImmutableException;

    public Datum copyDeleteAllFromKey(LispBag var1);

    public Datum deleteAllFromKey(LispBag var1) throws ImmutableException;

    public Datum copyAddFrom(LispDictionary var1);

    public Datum addFrom(LispDictionary var1) throws ImmutableException;

    public Datum copyReplaceAll(Datum var1, Datum[] var2);

    public Datum replaceAll(Datum var1, Datum[] var2) throws ImmutableException;

    public int countValue(Datum var1);

    public int countKey(Datum var1);

    public boolean equalToDictionary(LispDictionary var1, Procedure var2, Environment var3, LispMessage var4);

    public static class DictionaryAddFrom
    extends BinaryArgs {
        private Class<?> tocheck;
        private String errcd;

        public DictionaryAddFrom(Class<?> cls, String err) {
            this.tocheck = cls;
            this.errcd = err;
        }

        private void checkType(Datum c1a, LispMessage mesg) {
            SubrUtils.checkType(c1a, this.tocheck, mesg, this.errcd);
        }

        @Override
        protected Datum execute(Datum c1a, Datum c2a, Environment env, LispMessage mesg) {
            this.checkType(c1a, mesg);
            if (c2a instanceof LispDictionary) {
                try {
                    return ((LispDictionary)((Object)c1a)).copyAddFrom((LispDictionary)((Object)c2a));
                }
                catch (ClassCastException e) {
                    throw mesg.getError(e.getMessage(), c2a);
                }
            }
            throw mesg.getError("err.srfi44.require.map", c2a);
        }
    }

    public static class DictionaryAddFromS
    extends BinaryArgs {
        private Class<?> tocheck;
        private String errcd;

        public DictionaryAddFromS(Class<?> cls, String err) {
            this.tocheck = cls;
            this.errcd = err;
        }

        private void checkType(Datum c1a, LispMessage mesg) {
            SubrUtils.checkType(c1a, this.tocheck, mesg, this.errcd);
        }

        @Override
        protected Datum execute(Datum c1a, Datum c2a, Environment env, LispMessage mesg) {
            this.checkType(c1a, mesg);
            if (c2a instanceof LispDictionary) {
                try {
                    return ((LispDictionary)((Object)c1a)).addFrom((LispDictionary)((Object)c2a));
                }
                catch (ClassCastException e) {
                    throw mesg.getError(e.getMessage(), c2a);
                }
                catch (ImmutableException e) {
                    throw mesg.getError("err.srfi44.immutable", c2a);
                }
            }
            throw mesg.getError("err.srfi44.require.map", c2a);
        }
    }

    public static class DictionaryCount
    extends BinaryArgs {
        private Class<?> tocheck;
        private String errcd;

        public DictionaryCount(Class<?> cls, String err) {
            this.tocheck = cls;
            this.errcd = err;
        }

        private void checkType(Datum c1a, LispMessage mesg) {
            SubrUtils.checkType(c1a, this.tocheck, mesg, this.errcd);
        }

        @Override
        protected Datum execute(Datum c1a, Datum c2a, Environment env, LispMessage mesg) {
            this.checkType(c1a, mesg);
            return LispInteger.valueOf(((LispDictionary)((Object)c1a)).countValue(c2a));
        }
    }

    public static class DictionaryDelete
    extends BinaryArgs {
        private Class<?> tocheck;
        private String errcd;

        public DictionaryDelete(Class<?> cls, String err) {
            this.tocheck = cls;
            this.errcd = err;
        }

        private void checkType(Datum c1a, LispMessage mesg) {
            SubrUtils.checkType(c1a, this.tocheck, mesg, this.errcd);
        }

        @Override
        protected Datum execute(Datum c1a, Datum c2a, Environment env, LispMessage mesg) {
            this.checkType(c1a, mesg);
            try {
                return ((LispDictionary)((Object)c1a)).copyDeleteKey(c2a);
            }
            catch (ClassCastException e) {
                throw mesg.getError(e.getMessage(), c2a);
            }
        }
    }

    public static class DictionaryDeleteAll
    extends BinaryArgs {
        private Class<?> tocheck;
        private String errcd;

        public DictionaryDeleteAll(Class<?> cls, String err) {
            this.tocheck = cls;
            this.errcd = err;
        }

        private void checkType(Datum c1a, LispMessage mesg) {
            SubrUtils.checkType(c1a, this.tocheck, mesg, this.errcd);
        }

        @Override
        protected Datum execute(Datum c1a, Datum c2a, Environment env, LispMessage mesg) {
            this.checkType(c1a, mesg);
            try {
                return ((LispDictionary)((Object)c1a)).copyDeleteAllKey(c2a);
            }
            catch (ClassCastException e) {
                throw mesg.getError(e.getMessage(), c2a);
            }
        }
    }

    public static class DictionaryDeleteAllFrom
    extends BinaryArgs {
        private Class<?> tocheck;
        private String errcd;

        public DictionaryDeleteAllFrom(Class<?> cls, String err) {
            this.tocheck = cls;
            this.errcd = err;
        }

        private void checkType(Datum c1a, LispMessage mesg) {
            SubrUtils.checkType(c1a, this.tocheck, mesg, this.errcd);
        }

        @Override
        protected Datum execute(Datum c1a, Datum c2a, Environment env, LispMessage mesg) {
            this.checkType(c1a, mesg);
            if (c2a instanceof LispBag) {
                try {
                    return ((LispDictionary)((Object)c1a)).copyDeleteAllFromKey((LispBag)((Object)c2a));
                }
                catch (ClassCastException e) {
                    throw mesg.getError(e.getMessage(), c2a);
                }
            }
            throw mesg.getError("err.srfi44.require.bag", c2a);
        }
    }

    public static class DictionaryDeleteAllFromS
    extends BinaryArgs {
        private Class<?> tocheck;
        private String errcd;

        public DictionaryDeleteAllFromS(Class<?> cls, String err) {
            this.tocheck = cls;
            this.errcd = err;
        }

        private void checkType(Datum c1a, LispMessage mesg) {
            SubrUtils.checkType(c1a, this.tocheck, mesg, this.errcd);
        }

        @Override
        protected Datum execute(Datum c1a, Datum c2a, Environment env, LispMessage mesg) {
            this.checkType(c1a, mesg);
            if (c2a instanceof LispBag) {
                try {
                    return ((LispDictionary)((Object)c1a)).deleteAllFromKey((LispBag)((Object)c2a));
                }
                catch (ClassCastException e) {
                    throw mesg.getError(e.getMessage(), c2a);
                }
                catch (ImmutableException e) {
                    throw mesg.getError("err.srfi44.immutable", c1a);
                }
            }
            throw mesg.getError("err.srfi44.require.bag", c2a);
        }
    }

    public static class DictionaryDeleteAllS
    extends BinaryArgs {
        private Class<?> tocheck;
        private String errcd;

        public DictionaryDeleteAllS(Class<?> cls, String err) {
            this.tocheck = cls;
            this.errcd = err;
        }

        private void checkType(Datum c1a, LispMessage mesg) {
            SubrUtils.checkType(c1a, this.tocheck, mesg, this.errcd);
        }

        @Override
        protected Datum execute(Datum c1a, Datum c2a, Environment env, LispMessage mesg) {
            this.checkType(c1a, mesg);
            try {
                return ((LispDictionary)((Object)c1a)).deleteAllKey(c2a);
            }
            catch (ClassCastException e) {
                throw mesg.getError(e.getMessage(), c2a);
            }
            catch (ImmutableException e) {
                throw mesg.getError("err.srfi44.immutable", c1a);
            }
        }
    }

    public static class DictionaryDeleteFrom
    extends BinaryArgs {
        private Class<?> tocheck;
        private String errcd;

        public DictionaryDeleteFrom(Class<?> cls, String err) {
            this.tocheck = cls;
            this.errcd = err;
        }

        private void checkType(Datum c1a, LispMessage mesg) {
            SubrUtils.checkType(c1a, this.tocheck, mesg, this.errcd);
        }

        @Override
        protected Datum execute(Datum c1a, Datum c2a, Environment env, LispMessage mesg) {
            this.checkType(c1a, mesg);
            if (c2a instanceof LispBag) {
                try {
                    return ((LispDictionary)((Object)c1a)).copyDeleteFromKey((LispBag)((Object)c2a));
                }
                catch (ClassCastException e) {
                    throw mesg.getError(e.getMessage(), c2a);
                }
            }
            throw mesg.getError("err.srfi44.require.bag", c2a);
        }
    }

    public static class DictionaryDeleteFromS
    extends BinaryArgs {
        private Class<?> tocheck;
        private String errcd;

        public DictionaryDeleteFromS(Class<?> cls, String err) {
            this.tocheck = cls;
            this.errcd = err;
        }

        private void checkType(Datum c1a, LispMessage mesg) {
            SubrUtils.checkType(c1a, this.tocheck, mesg, this.errcd);
        }

        @Override
        protected Datum execute(Datum c1a, Datum c2a, Environment env, LispMessage mesg) {
            this.checkType(c1a, mesg);
            if (c2a instanceof LispBag) {
                try {
                    return ((LispDictionary)((Object)c1a)).deleteFromKey((LispBag)((Object)c2a));
                }
                catch (ClassCastException e) {
                    throw mesg.getError(e.getMessage(), c2a);
                }
                catch (ImmutableException e) {
                    throw mesg.getError("err.srfi44.immutable", c2a);
                }
            }
            throw mesg.getError("err.srfi44.require.bag", c2a);
        }
    }

    public static class DictionaryDeleteS
    extends BinaryArgs {
        private Class<?> tocheck;
        private String errcd;

        public DictionaryDeleteS(Class<?> cls, String err) {
            this.tocheck = cls;
            this.errcd = err;
        }

        private void checkType(Datum c1a, LispMessage mesg) {
            SubrUtils.checkType(c1a, this.tocheck, mesg, this.errcd);
        }

        @Override
        protected Datum execute(Datum c1a, Datum c2a, Environment env, LispMessage mesg) {
            this.checkType(c1a, mesg);
            try {
                return ((LispDictionary)((Object)c1a)).deleteKey(c2a);
            }
            catch (ClassCastException e) {
                throw mesg.getError(e.getMessage(), c2a);
            }
            catch (ImmutableException e) {
                throw mesg.getError("err.srfi44.immutable", c1a);
            }
        }
    }

    public static class DictionaryEq
    extends Subr {
        private Class<?> tocheck;
        private String errcd;

        public DictionaryEq(Class<?> cls, String err) {
            this.tocheck = cls;
            this.errcd = err;
        }

        private void checkType(Datum c1a, LispMessage mesg) {
            SubrUtils.checkType(c1a, this.tocheck, mesg, this.errcd);
        }

        /*
         * Unable to fully structure code
         */
        @Override
        public Datum eval(Datum body, Environment env, LispMessage mesg) {
            itr = new ConsIterator(body);
            p = SubrUtils.nextIf((Iterator<Datum>)itr, mesg, body);
            d = null;
            r = true;
            if (p instanceof Procedure) ** GOTO lbl16
            throw mesg.getError("err.require.procedure", p);
lbl-1000:
            // 1 sources

            {
                e = itr.next();
                this.checkType(e, mesg);
                if (d == null) {
                    d = (LispDictionary)e;
                    continue;
                }
                if (!(e instanceof LispCollection)) {
                    throw mesg.getError("err.srfi44.require.collection", e);
                }
                if (!r) continue;
                r = d.equalToDictionary((LispDictionary)e, (Procedure)p, env, mesg);
lbl16:
                // 4 sources

                ** while (itr.hasNext())
            }
lbl17:
            // 1 sources

            SubrUtils.checkTerminated(itr, body, mesg);
            return LispBoolean.getInstance(r);
        }
    }

    public static class DictionaryEquivalenceFunction
    extends UnaryArgs {
        private Class<?> tocheck;
        private String errcd;

        public DictionaryEquivalenceFunction(Class<?> cls, String err) {
            this.tocheck = cls;
            this.errcd = err;
        }

        private void checkType(Datum c1a, LispMessage mesg) {
            SubrUtils.checkType(c1a, this.tocheck, mesg, this.errcd);
        }

        @Override
        protected Datum execute(Datum c1a, Environment env, LispMessage mesg) {
            this.checkType(c1a, mesg);
            return (Datum)((Object)((LispDictionary)((Object)c1a)).valueEquivalence());
        }
    }

    public static class DictionaryGet
    extends Subr {
        private Class<?> tocheck;
        private String errcd;

        public DictionaryGet(Class<?> cls, String err) {
            this.tocheck = cls;
            this.errcd = err;
        }

        private void checkType(Datum c1a, LispMessage mesg) {
            SubrUtils.checkType(c1a, this.tocheck, mesg, this.errcd);
        }

        @Override
        public Datum eval(Datum body, Environment env, LispMessage mesg) {
            ConsIterator itr = new ConsIterator(body);
            Datum d = SubrUtils.nextIf((Iterator<Datum>)itr, mesg, body);
            Datum k = SubrUtils.nextIf((Iterator<Datum>)itr, mesg, body);
            Datum th = Iterators.nextIf(itr, null);
            SubrUtils.checkTerminated(itr, body, mesg);
            this.checkType(d, mesg);
            try {
                Datum r = ((LispDictionary)((Object)d)).get(k);
                if (r != null) {
                    return r;
                }
                if (th == null) {
                    return LispBoolean.FALSE;
                }
                if (th instanceof Procedure) {
                    return Scheme.callva(th, env, mesg, new Datum[0]);
                }
                throw mesg.getError("err.require.procedure", th);
            }
            catch (ClassCastException e) {
                throw mesg.getError(e.getMessage(), k);
            }
        }
    }

    public static class DictionaryGetAll
    extends Subr {
        private Class<?> tocheck;
        private String errcd;

        public DictionaryGetAll(Class<?> cls, String err) {
            this.tocheck = cls;
            this.errcd = err;
        }

        private void checkType(Datum c1a, LispMessage mesg) {
            SubrUtils.checkType(c1a, this.tocheck, mesg, this.errcd);
        }

        @Override
        public Datum eval(Datum body, Environment env, LispMessage mesg) {
            ConsIterator itr = new ConsIterator(body);
            Datum d = SubrUtils.nextIf((Iterator<Datum>)itr, mesg, body);
            Datum k = SubrUtils.nextIf((Iterator<Datum>)itr, mesg, body);
            SubrUtils.checkTerminated(itr, body, mesg);
            this.checkType(d, mesg);
            return ((LispDictionary)((Object)d)).getAllAsList(k);
        }
    }

    public static class DictionaryKeyCount
    extends BinaryArgs {
        private Class<?> tocheck;
        private String errcd;

        public DictionaryKeyCount(Class<?> cls, String err) {
            this.tocheck = cls;
            this.errcd = err;
        }

        private void checkType(Datum c1a, LispMessage mesg) {
            SubrUtils.checkType(c1a, this.tocheck, mesg, this.errcd);
        }

        @Override
        protected Datum execute(Datum c1a, Datum c2a, Environment env, LispMessage mesg) {
            this.checkType(c1a, mesg);
            return LispInteger.valueOf(((LispDictionary)((Object)c1a)).countKey(c2a));
        }
    }

    public static class DictionaryKeyEquivalenceFunction
    extends UnaryArgs {
        private Class<?> tocheck;
        private String errcd;

        public DictionaryKeyEquivalenceFunction(Class<?> cls, String err) {
            this.tocheck = cls;
            this.errcd = err;
        }

        private void checkType(Datum c1a, LispMessage mesg) {
            SubrUtils.checkType(c1a, this.tocheck, mesg, this.errcd);
        }

        @Override
        protected Datum execute(Datum c1a, Environment env, LispMessage mesg) {
            this.checkType(c1a, mesg);
            return (Datum)((Object)((LispDictionary)((Object)c1a)).keyEquivalence());
        }
    }

    public static class DictionaryKeysToList
    extends UnaryArgs {
        private Class<?> tocheck;
        private String errcd;

        public DictionaryKeysToList(Class<?> cls, String err) {
            this.tocheck = cls;
            this.errcd = err;
        }

        private void checkType(Datum c1a, LispMessage mesg) {
            SubrUtils.checkType(c1a, this.tocheck, mesg, this.errcd);
        }

        @Override
        protected Datum execute(Datum c1a, Environment env, LispMessage mesg) {
            this.checkType(c1a, mesg);
            return ((LispDictionary)((Object)c1a)).keysToList();
        }
    }

    public static class DictionaryPut
    extends Subr {
        private Class<?> tocheck;
        private String errcd;

        public DictionaryPut(Class<?> cls, String err) {
            this.tocheck = cls;
            this.errcd = err;
        }

        private void checkType(Datum c1a, LispMessage mesg) {
            SubrUtils.checkType(c1a, this.tocheck, mesg, this.errcd);
        }

        @Override
        public Datum eval(Datum body, Environment env, LispMessage mesg) {
            ConsIterator itr = new ConsIterator(body);
            Datum d = SubrUtils.nextIf((Iterator<Datum>)itr, mesg, body);
            Datum k = SubrUtils.nextIf((Iterator<Datum>)itr, mesg, body);
            Datum v = SubrUtils.nextIf((Iterator<Datum>)itr, mesg, body);
            Datum th = Iterators.nextIf(itr, null);
            SubrUtils.checkTerminated(itr, body, mesg);
            this.checkType(d, mesg);
            try {
                Datum[] r = ((LispDictionary)((Object)d)).copyPut(k, v);
                if (r[1] != null) {
                    return MultiValues.newValues(r);
                }
                if (th == null) {
                    return MultiValues.newValues(r[0], LispBoolean.FALSE);
                }
                if (th instanceof Procedure) {
                    return MultiValues.newValues(r[0], Scheme.callva(th, env, mesg, new Datum[0]));
                }
                throw mesg.getError("err.require.procedure", th);
            }
            catch (ClassCastException e) {
                throw mesg.getError(e.getMessage(), k);
            }
        }
    }

    public static class DictionaryPutS
    extends Subr {
        private Class<?> tocheck;
        private String errcd;

        public DictionaryPutS(Class<?> cls, String err) {
            this.tocheck = cls;
            this.errcd = err;
        }

        private void checkType(Datum c1a, LispMessage mesg) {
            SubrUtils.checkType(c1a, this.tocheck, mesg, this.errcd);
        }

        @Override
        public Datum eval(Datum body, Environment env, LispMessage mesg) {
            ConsIterator itr = new ConsIterator(body);
            Datum d = SubrUtils.nextIf((Iterator<Datum>)itr, mesg, body);
            Datum k = SubrUtils.nextIf((Iterator<Datum>)itr, mesg, body);
            Datum v = SubrUtils.nextIf((Iterator<Datum>)itr, mesg, body);
            Datum th = Iterators.nextIf(itr, null);
            SubrUtils.checkTerminated(itr, body, mesg);
            this.checkType(d, mesg);
            try {
                Datum[] r = ((LispDictionary)((Object)d)).put(k, v);
                if (r[1] != null) {
                    return MultiValues.newValues(r);
                }
                if (th == null) {
                    return MultiValues.newValues(r[0], LispBoolean.FALSE);
                }
                if (th instanceof Procedure) {
                    return MultiValues.newValues(r[0], Scheme.callva(th, env, mesg, new Datum[0]));
                }
                throw mesg.getError("err.require.procedure", th);
            }
            catch (ClassCastException e) {
                throw mesg.getError(e.getMessage(), k);
            }
            catch (ImmutableException e) {
                throw mesg.getError("err.srfi44.immutable", d);
            }
        }
    }

    public static class DictionaryReplaceAll
    extends Subr {
        private Class<?> tocheck;
        private String errcd;

        public DictionaryReplaceAll(Class<?> cls, String err) {
            this.tocheck = cls;
            this.errcd = err;
        }

        private void checkType(Datum c1a, LispMessage mesg) {
            SubrUtils.checkType(c1a, this.tocheck, mesg, this.errcd);
        }

        @Override
        public Datum eval(Datum body, Environment env, LispMessage mesg) {
            ConsIterator itr = new ConsIterator(body);
            Datum d = SubrUtils.nextIf((Iterator<Datum>)itr, mesg, body);
            Datum k = SubrUtils.nextIf((Iterator<Datum>)itr, mesg, body);
            Datum v = itr.rest();
            SubrUtils.checkTerminated(itr, body, mesg);
            this.checkType(d, mesg);
            try {
                return ((LispDictionary)((Object)d)).copyReplaceAll(k, LispUtils.toArray(v, mesg));
            }
            catch (ClassCastException e) {
                throw mesg.getError(e.getMessage(), k);
            }
        }
    }

    public static class DictionaryReplaceAllS
    extends Subr {
        private Class<?> tocheck;
        private String errcd;

        public DictionaryReplaceAllS(Class<?> cls, String err) {
            this.tocheck = cls;
            this.errcd = err;
        }

        private void checkType(Datum c1a, LispMessage mesg) {
            SubrUtils.checkType(c1a, this.tocheck, mesg, this.errcd);
        }

        @Override
        public Datum eval(Datum body, Environment env, LispMessage mesg) {
            ConsIterator itr = new ConsIterator(body);
            Datum d = SubrUtils.nextIf((Iterator<Datum>)itr, mesg, body);
            Datum k = SubrUtils.nextIf((Iterator<Datum>)itr, mesg, body);
            Datum v = itr.rest();
            SubrUtils.checkTerminated(itr, body, mesg);
            this.checkType(d, mesg);
            try {
                return ((LispDictionary)((Object)d)).replaceAll(k, LispUtils.toArray(v, mesg));
            }
            catch (ClassCastException e) {
                throw mesg.getError(e.getMessage(), k);
            }
            catch (ImmutableException e) {
                throw mesg.getError("err.srfi44.immutable", d);
            }
        }
    }

    public static class DictionaryUpdate
    extends Subr {
        private Class<?> tocheck;
        private String errcd;

        public DictionaryUpdate(Class<?> cls, String err) {
            this.tocheck = cls;
            this.errcd = err;
        }

        private void checkType(Datum c1a, LispMessage mesg) {
            SubrUtils.checkType(c1a, this.tocheck, mesg, this.errcd);
        }

        @Override
        public Datum eval(Datum body, Environment env, LispMessage mesg) {
            ConsIterator itr = new ConsIterator(body);
            Datum d = SubrUtils.nextIf((Iterator<Datum>)itr, mesg, body);
            Datum k = SubrUtils.nextIf((Iterator<Datum>)itr, mesg, body);
            Datum f = SubrUtils.nextIf((Iterator<Datum>)itr, mesg, body);
            Datum th = Iterators.nextIf(itr, null);
            SubrUtils.checkTerminated(itr, body, mesg);
            this.checkType(d, mesg);
            SubrUtils.checkType(f, Procedure.class, mesg, "err.require.procedure");
            try {
                Datum y;
                Datum x = ((LispDictionary)((Object)d)).get(k);
                if (x != null) {
                    y = Scheme.callva(f, env, mesg, x);
                } else if (th == null) {
                    y = LispBoolean.FALSE;
                } else if (th instanceof Procedure) {
                    y = Scheme.callva(th, env, mesg, new Datum[0]);
                } else {
                    throw mesg.getError("err.require.procedure", th);
                }
                Datum[] r = ((LispDictionary)((Object)d)).copyPut(k, y);
                return r[0];
            }
            catch (ClassCastException e) {
                throw mesg.getError(e.getMessage(), k);
            }
        }
    }

    public static class DictionaryUpdateAll
    extends Subr {
        private Class<?> tocheck;
        private String errcd;

        public DictionaryUpdateAll(Class<?> cls, String err) {
            this.tocheck = cls;
            this.errcd = err;
        }

        private void checkType(Datum c1a, LispMessage mesg) {
            SubrUtils.checkType(c1a, this.tocheck, mesg, this.errcd);
        }

        @Override
        public Datum eval(Datum body, Environment env, LispMessage mesg) {
            ConsIterator itr = new ConsIterator(body);
            Datum d = SubrUtils.nextIf((Iterator<Datum>)itr, mesg, body);
            Datum k = SubrUtils.nextIf((Iterator<Datum>)itr, mesg, body);
            Datum f = SubrUtils.nextIf((Iterator<Datum>)itr, mesg, body);
            Datum th = Iterators.nextIf(itr, null);
            SubrUtils.checkTerminated(itr, body, mesg);
            this.checkType(d, mesg);
            SubrUtils.checkType(f, Procedure.class, mesg, "err.require.procedure");
            try {
                if (th != null && !(th instanceof Procedure)) {
                    throw mesg.getError("err,require.procedure", th);
                }
                return ((LispDictionary)((Object)d)).copyUpdateAll(k, (Procedure)((Object)f), (Procedure)((Object)th), env, mesg);
            }
            catch (ClassCastException e) {
                throw mesg.getError(e.getMessage(), k);
            }
        }
    }

    public static class DictionaryUpdateAllS
    extends Subr {
        private Class<?> tocheck;
        private String errcd;

        public DictionaryUpdateAllS(Class<?> cls, String err) {
            this.tocheck = cls;
            this.errcd = err;
        }

        private void checkType(Datum c1a, LispMessage mesg) {
            SubrUtils.checkType(c1a, this.tocheck, mesg, this.errcd);
        }

        @Override
        public Datum eval(Datum body, Environment env, LispMessage mesg) {
            ConsIterator itr = new ConsIterator(body);
            Datum d = SubrUtils.nextIf((Iterator<Datum>)itr, mesg, body);
            Datum k = SubrUtils.nextIf((Iterator<Datum>)itr, mesg, body);
            Datum f = SubrUtils.nextIf((Iterator<Datum>)itr, mesg, body);
            Datum th = Iterators.nextIf(itr, null);
            SubrUtils.checkTerminated(itr, body, mesg);
            this.checkType(d, mesg);
            SubrUtils.checkType(f, Procedure.class, mesg, "err.require.procedure");
            try {
                if (th != null && !(th instanceof Procedure)) {
                    throw mesg.getError("err,require.procedure", th);
                }
                return ((LispDictionary)((Object)d)).updateAll(k, (Procedure)((Object)f), (Procedure)((Object)th), env, mesg);
            }
            catch (ClassCastException e) {
                throw mesg.getError(e.getMessage(), k);
            }
            catch (ImmutableException e) {
                throw mesg.getError("err.srfi44.immutable", d);
            }
        }
    }

    public static class DictionaryUpdateS
    extends Subr {
        private Class<?> tocheck;
        private String errcd;

        public DictionaryUpdateS(Class<?> cls, String err) {
            this.tocheck = cls;
            this.errcd = err;
        }

        private void checkType(Datum c1a, LispMessage mesg) {
            SubrUtils.checkType(c1a, this.tocheck, mesg, this.errcd);
        }

        @Override
        public Datum eval(Datum body, Environment env, LispMessage mesg) {
            ConsIterator itr = new ConsIterator(body);
            Datum d = SubrUtils.nextIf((Iterator<Datum>)itr, mesg, body);
            Datum k = SubrUtils.nextIf((Iterator<Datum>)itr, mesg, body);
            Datum f = SubrUtils.nextIf((Iterator<Datum>)itr, mesg, body);
            Datum th = Iterators.nextIf(itr, null);
            SubrUtils.checkTerminated(itr, body, mesg);
            this.checkType(d, mesg);
            SubrUtils.checkType(f, Procedure.class, mesg, "err.require.procedure");
            try {
                Datum y;
                Datum x = ((LispDictionary)((Object)d)).get(k);
                if (x != null) {
                    y = Scheme.callva(f, env, mesg, x);
                } else if (th == null) {
                    y = LispBoolean.FALSE;
                } else if (th instanceof Procedure) {
                    y = Scheme.callva(th, env, mesg, new Datum[0]);
                } else {
                    throw mesg.getError("err.require.procedure", th);
                }
                Datum[] r = ((LispDictionary)((Object)d)).put(k, y);
                return r[0];
            }
            catch (ClassCastException e) {
                throw mesg.getError(e.getMessage(), k);
            }
            catch (ImmutableException e) {
                throw mesg.getError("err.srfi44.immutable", d);
            }
        }
    }

    public static class IsDictionary
    extends UnaryArgs {
        @Override
        protected Datum execute(Datum c1a, Environment env, LispMessage mesg) {
            return LispBoolean.getInstance(c1a instanceof LispDictionary);
        }
    }

    public static class IsDictionaryContainsKey
    extends BinaryArgs {
        private Class<?> tocheck;
        private String errcd;

        public IsDictionaryContainsKey(Class<?> cls, String err) {
            this.tocheck = cls;
            this.errcd = err;
        }

        private void checkType(Datum c1a, LispMessage mesg) {
            SubrUtils.checkType(c1a, this.tocheck, mesg, this.errcd);
        }

        @Override
        protected Datum execute(Datum c1a, Datum c2a, Environment env, LispMessage mesg) {
            this.checkType(c1a, mesg);
            try {
                return LispBoolean.getInstance(((LispDictionary)((Object)c1a)).containsKey(c2a));
            }
            catch (ClassCastException e) {
                throw mesg.getError(e.getMessage(), c2a);
            }
        }
    }
}

