/*
 * Decompiled with CFR 0.152.
 */
package net.morilib.lisp.collection;

import java.util.Iterator;
import net.morilib.lisp.ConsIterator;
import net.morilib.lisp.Datum;
import net.morilib.lisp.Environment;
import net.morilib.lisp.LispBoolean;
import net.morilib.lisp.LispInteger;
import net.morilib.lisp.LispMessage;
import net.morilib.lisp.MultiValues;
import net.morilib.lisp.Procedure;
import net.morilib.lisp.SExpressionDatum;
import net.morilib.lisp.Scheme;
import net.morilib.lisp.Subr;
import net.morilib.lisp.accessor.ILispRef;
import net.morilib.lisp.collection.ImmutableException;
import net.morilib.lisp.collection.LispBag;
import net.morilib.lisp.collection.LispCollection;
import net.morilib.lisp.collection.LispEntryEnumeration;
import net.morilib.lisp.subr.BinaryArgs;
import net.morilib.lisp.subr.SubrUtils;
import net.morilib.lisp.subr.UnaryArgs;
import net.morilib.util.Iterators;

public interface LispMap
extends LispCollection,
LispEntryEnumeration,
ILispRef {
    public Procedure keyEquivalence();

    public boolean equivalenceKey(Datum var1, Datum var2);

    public Procedure valueEquivalence();

    public boolean equivalenceValue(Datum var1, Datum var2);

    public boolean containsKey(Datum var1);

    public SExpressionDatum keysToList();

    public Datum get(Datum var1);

    public Datum[] copyPut(Datum var1, Datum var2);

    public Datum[] put(Datum var1, Datum var2) throws ImmutableException;

    public Datum copyDeleteKey(Datum var1);

    public Datum deleteKey(Datum var1) throws ImmutableException;

    public Datum copyDeleteFromKey(LispBag var1);

    public Datum deleteFromKey(LispBag var1) throws ImmutableException;

    public Datum copyAddFrom(LispMap var1);

    public Datum addFrom(LispMap var1) throws ImmutableException;

    public int countValue(Datum var1);

    public boolean equalToMap(LispMap var1, Procedure var2, Environment var3, LispMessage var4);

    public static class IsMap
    extends UnaryArgs {
        @Override
        protected Datum execute(Datum c1a, Environment env, LispMessage mesg) {
            return LispBoolean.getInstance(c1a instanceof LispMap);
        }
    }

    public static class IsMapContainsKey
    extends BinaryArgs {
        private Class<?> tocheck;
        private String errcd;

        public IsMapContainsKey(Class<?> cls, String err) {
            this.tocheck = cls;
            this.errcd = err;
        }

        private void checkType(Datum c1a, LispMessage mesg) {
            SubrUtils.checkType(c1a, this.tocheck, mesg, this.errcd);
        }

        @Override
        protected Datum execute(Datum c1a, Datum c2a, Environment env, LispMessage mesg) {
            this.checkType(c1a, mesg);
            try {
                return LispBoolean.getInstance(((LispMap)((Object)c1a)).containsKey(c2a));
            }
            catch (ClassCastException e) {
                throw mesg.getError(e.getMessage(), c2a);
            }
        }
    }

    public static class MapAddFrom
    extends BinaryArgs {
        private Class<?> tocheck;
        private String errcd;

        public MapAddFrom(Class<?> cls, String err) {
            this.tocheck = cls;
            this.errcd = err;
        }

        private void checkType(Datum c1a, LispMessage mesg) {
            SubrUtils.checkType(c1a, this.tocheck, mesg, this.errcd);
        }

        @Override
        protected Datum execute(Datum c1a, Datum c2a, Environment env, LispMessage mesg) {
            this.checkType(c1a, mesg);
            if (c2a instanceof LispMap) {
                try {
                    return ((LispMap)((Object)c1a)).copyAddFrom((LispMap)((Object)c2a));
                }
                catch (ClassCastException e) {
                    throw mesg.getError(e.getMessage(), c2a);
                }
            }
            throw mesg.getError("err.srfi44.require.map", c2a);
        }
    }

    public static class MapAddFromS
    extends BinaryArgs {
        private Class<?> tocheck;
        private String errcd;

        public MapAddFromS(Class<?> cls, String err) {
            this.tocheck = cls;
            this.errcd = err;
        }

        private void checkType(Datum c1a, LispMessage mesg) {
            SubrUtils.checkType(c1a, this.tocheck, mesg, this.errcd);
        }

        @Override
        protected Datum execute(Datum c1a, Datum c2a, Environment env, LispMessage mesg) {
            this.checkType(c1a, mesg);
            if (c2a instanceof LispMap) {
                try {
                    return ((LispMap)((Object)c1a)).addFrom((LispMap)((Object)c2a));
                }
                catch (ClassCastException e) {
                    throw mesg.getError(e.getMessage(), c2a);
                }
                catch (ImmutableException e) {
                    throw mesg.getError("err.srfi44.immutable", c2a);
                }
            }
            throw mesg.getError("err.srfi44.require.map", c2a);
        }
    }

    public static class MapCount
    extends BinaryArgs {
        private Class<?> tocheck;
        private String errcd;

        public MapCount(Class<?> cls, String err) {
            this.tocheck = cls;
            this.errcd = err;
        }

        private void checkType(Datum c1a, LispMessage mesg) {
            SubrUtils.checkType(c1a, this.tocheck, mesg, this.errcd);
        }

        @Override
        protected Datum execute(Datum c1a, Datum c2a, Environment env, LispMessage mesg) {
            this.checkType(c1a, mesg);
            return LispInteger.valueOf(((LispMap)((Object)c1a)).countValue(c2a));
        }
    }

    public static class MapDelete
    extends BinaryArgs {
        private Class<?> tocheck;
        private String errcd;

        public MapDelete(Class<?> cls, String err) {
            this.tocheck = cls;
            this.errcd = err;
        }

        private void checkType(Datum c1a, LispMessage mesg) {
            SubrUtils.checkType(c1a, this.tocheck, mesg, this.errcd);
        }

        @Override
        protected Datum execute(Datum c1a, Datum c2a, Environment env, LispMessage mesg) {
            this.checkType(c1a, mesg);
            try {
                return ((LispMap)((Object)c1a)).copyDeleteKey(c2a);
            }
            catch (ClassCastException e) {
                throw mesg.getError(e.getMessage(), c2a);
            }
        }
    }

    public static class MapDeleteFrom
    extends BinaryArgs {
        private Class<?> tocheck;
        private String errcd;

        public MapDeleteFrom(Class<?> cls, String err) {
            this.tocheck = cls;
            this.errcd = err;
        }

        private void checkType(Datum c1a, LispMessage mesg) {
            SubrUtils.checkType(c1a, this.tocheck, mesg, this.errcd);
        }

        @Override
        protected Datum execute(Datum c1a, Datum c2a, Environment env, LispMessage mesg) {
            this.checkType(c1a, mesg);
            if (c2a instanceof LispBag) {
                try {
                    return ((LispMap)((Object)c1a)).copyDeleteFromKey((LispBag)((Object)c2a));
                }
                catch (ClassCastException e) {
                    throw mesg.getError(e.getMessage(), c2a);
                }
            }
            throw mesg.getError("err.srfi44.require.bag", c2a);
        }
    }

    public static class MapDeleteFromS
    extends BinaryArgs {
        private Class<?> tocheck;
        private String errcd;

        public MapDeleteFromS(Class<?> cls, String err) {
            this.tocheck = cls;
            this.errcd = err;
        }

        private void checkType(Datum c1a, LispMessage mesg) {
            SubrUtils.checkType(c1a, this.tocheck, mesg, this.errcd);
        }

        @Override
        protected Datum execute(Datum c1a, Datum c2a, Environment env, LispMessage mesg) {
            this.checkType(c1a, mesg);
            if (c2a instanceof LispBag) {
                try {
                    return ((LispMap)((Object)c1a)).deleteFromKey((LispBag)((Object)c2a));
                }
                catch (ClassCastException e) {
                    throw mesg.getError(e.getMessage(), c2a);
                }
                catch (ImmutableException e) {
                    throw mesg.getError("err.srfi44.immutable", c2a);
                }
            }
            throw mesg.getError("err.srfi44.require.bag", c2a);
        }
    }

    public static class MapDeleteS
    extends BinaryArgs {
        private Class<?> tocheck;
        private String errcd;

        public MapDeleteS(Class<?> cls, String err) {
            this.tocheck = cls;
            this.errcd = err;
        }

        private void checkType(Datum c1a, LispMessage mesg) {
            SubrUtils.checkType(c1a, this.tocheck, mesg, this.errcd);
        }

        @Override
        protected Datum execute(Datum c1a, Datum c2a, Environment env, LispMessage mesg) {
            this.checkType(c1a, mesg);
            try {
                return ((LispMap)((Object)c1a)).deleteKey(c2a);
            }
            catch (ClassCastException e) {
                throw mesg.getError(e.getMessage(), c2a);
            }
            catch (ImmutableException e) {
                throw mesg.getError("err.srfi44.immutable", c1a);
            }
        }
    }

    public static class MapEq
    extends Subr {
        private Class<?> tocheck;
        private String errcd;

        public MapEq(Class<?> cls, String err) {
            this.tocheck = cls;
            this.errcd = err;
        }

        private void checkType(Datum c1a, LispMessage mesg) {
            SubrUtils.checkType(c1a, this.tocheck, mesg, this.errcd);
        }

        /*
         * Unable to fully structure code
         */
        @Override
        public Datum eval(Datum body, Environment env, LispMessage mesg) {
            itr = new ConsIterator(body);
            p = SubrUtils.nextIf((Iterator<Datum>)itr, mesg, body);
            d = null;
            r = true;
            if (p instanceof Procedure) ** GOTO lbl16
            throw mesg.getError("err.require.procedure", p);
lbl-1000:
            // 1 sources

            {
                e = itr.next();
                this.checkType(e, mesg);
                if (d == null) {
                    d = (LispMap)e;
                    continue;
                }
                if (!(e instanceof LispCollection)) {
                    throw mesg.getError("err.srfi44.require.collection", e);
                }
                if (!r) continue;
                r = d.equalToMap((LispMap)e, (Procedure)p, env, mesg);
lbl16:
                // 4 sources

                ** while (itr.hasNext())
            }
lbl17:
            // 1 sources

            SubrUtils.checkTerminated(itr, body, mesg);
            return LispBoolean.getInstance(r);
        }
    }

    public static class MapEquivalenceFunction
    extends UnaryArgs {
        private Class<?> tocheck;
        private String errcd;

        public MapEquivalenceFunction(Class<?> cls, String err) {
            this.tocheck = cls;
            this.errcd = err;
        }

        private void checkType(Datum c1a, LispMessage mesg) {
            SubrUtils.checkType(c1a, this.tocheck, mesg, this.errcd);
        }

        @Override
        protected Datum execute(Datum c1a, Environment env, LispMessage mesg) {
            this.checkType(c1a, mesg);
            return (Datum)((Object)((LispMap)((Object)c1a)).valueEquivalence());
        }
    }

    public static class MapGet
    extends Subr {
        private Class<?> tocheck;
        private String errcd;

        public MapGet(Class<?> cls, String err) {
            this.tocheck = cls;
            this.errcd = err;
        }

        private void checkType(Datum c1a, LispMessage mesg) {
            SubrUtils.checkType(c1a, this.tocheck, mesg, this.errcd);
        }

        @Override
        public Datum eval(Datum body, Environment env, LispMessage mesg) {
            ConsIterator itr = new ConsIterator(body);
            Datum d = SubrUtils.nextIf((Iterator<Datum>)itr, mesg, body);
            Datum k = SubrUtils.nextIf((Iterator<Datum>)itr, mesg, body);
            Datum th = Iterators.nextIf(itr, null);
            SubrUtils.checkTerminated(itr, body, mesg);
            this.checkType(d, mesg);
            try {
                Datum r = ((LispMap)((Object)d)).get(k);
                if (r != null) {
                    return r;
                }
                if (th == null) {
                    return LispBoolean.FALSE;
                }
                if (th instanceof Procedure) {
                    return Scheme.callva(th, env, mesg, new Datum[0]);
                }
                throw mesg.getError("err.require.procedure", th);
            }
            catch (ClassCastException e) {
                throw mesg.getError(e.getMessage(), k);
            }
        }
    }

    public static class MapKeyEquivalenceFunction
    extends UnaryArgs {
        private Class<?> tocheck;
        private String errcd;

        public MapKeyEquivalenceFunction(Class<?> cls, String err) {
            this.tocheck = cls;
            this.errcd = err;
        }

        private void checkType(Datum c1a, LispMessage mesg) {
            SubrUtils.checkType(c1a, this.tocheck, mesg, this.errcd);
        }

        @Override
        protected Datum execute(Datum c1a, Environment env, LispMessage mesg) {
            this.checkType(c1a, mesg);
            return (Datum)((Object)((LispMap)((Object)c1a)).keyEquivalence());
        }
    }

    public static class MapKeysToList
    extends UnaryArgs {
        private Class<?> tocheck;
        private String errcd;

        public MapKeysToList(Class<?> cls, String err) {
            this.tocheck = cls;
            this.errcd = err;
        }

        private void checkType(Datum c1a, LispMessage mesg) {
            SubrUtils.checkType(c1a, this.tocheck, mesg, this.errcd);
        }

        @Override
        protected Datum execute(Datum c1a, Environment env, LispMessage mesg) {
            this.checkType(c1a, mesg);
            return ((LispMap)((Object)c1a)).keysToList();
        }
    }

    public static class MapPut
    extends Subr {
        private Class<?> tocheck;
        private String errcd;

        public MapPut(Class<?> cls, String err) {
            this.tocheck = cls;
            this.errcd = err;
        }

        private void checkType(Datum c1a, LispMessage mesg) {
            SubrUtils.checkType(c1a, this.tocheck, mesg, this.errcd);
        }

        @Override
        public Datum eval(Datum body, Environment env, LispMessage mesg) {
            ConsIterator itr = new ConsIterator(body);
            Datum d = SubrUtils.nextIf((Iterator<Datum>)itr, mesg, body);
            Datum k = SubrUtils.nextIf((Iterator<Datum>)itr, mesg, body);
            Datum v = SubrUtils.nextIf((Iterator<Datum>)itr, mesg, body);
            Datum th = Iterators.nextIf(itr, null);
            SubrUtils.checkTerminated(itr, body, mesg);
            this.checkType(d, mesg);
            try {
                Datum[] r = ((LispMap)((Object)d)).copyPut(k, v);
                if (r[1] != null) {
                    return MultiValues.newValues(r);
                }
                if (th == null) {
                    return MultiValues.newValues(r[0], LispBoolean.FALSE);
                }
                if (th instanceof Procedure) {
                    return MultiValues.newValues(r[0], Scheme.callva(th, env, mesg, new Datum[0]));
                }
                throw mesg.getError("err.require.procedure", th);
            }
            catch (ClassCastException e) {
                throw mesg.getError(e.getMessage(), k);
            }
        }
    }

    public static class MapPutS
    extends Subr {
        private Class<?> tocheck;
        private String errcd;

        public MapPutS(Class<?> cls, String err) {
            this.tocheck = cls;
            this.errcd = err;
        }

        private void checkType(Datum c1a, LispMessage mesg) {
            SubrUtils.checkType(c1a, this.tocheck, mesg, this.errcd);
        }

        @Override
        public Datum eval(Datum body, Environment env, LispMessage mesg) {
            ConsIterator itr = new ConsIterator(body);
            Datum d = SubrUtils.nextIf((Iterator<Datum>)itr, mesg, body);
            Datum k = SubrUtils.nextIf((Iterator<Datum>)itr, mesg, body);
            Datum v = SubrUtils.nextIf((Iterator<Datum>)itr, mesg, body);
            Datum th = Iterators.nextIf(itr, null);
            SubrUtils.checkTerminated(itr, body, mesg);
            this.checkType(d, mesg);
            try {
                Datum[] r = ((LispMap)((Object)d)).put(k, v);
                if (r[1] != null) {
                    return MultiValues.newValues(r);
                }
                if (th == null) {
                    return MultiValues.newValues(r[0], LispBoolean.FALSE);
                }
                if (th instanceof Procedure) {
                    return MultiValues.newValues(r[0], Scheme.callva(th, env, mesg, new Datum[0]));
                }
                throw mesg.getError("err.require.procedure", th);
            }
            catch (ClassCastException e) {
                throw mesg.getError(e.getMessage(), k);
            }
            catch (ImmutableException e) {
                throw mesg.getError("err.srfi44.immutable", d);
            }
        }
    }

    public static class MapUpdate
    extends Subr {
        private Class<?> tocheck;
        private String errcd;

        public MapUpdate(Class<?> cls, String err) {
            this.tocheck = cls;
            this.errcd = err;
        }

        private void checkType(Datum c1a, LispMessage mesg) {
            SubrUtils.checkType(c1a, this.tocheck, mesg, this.errcd);
        }

        @Override
        public Datum eval(Datum body, Environment env, LispMessage mesg) {
            ConsIterator itr = new ConsIterator(body);
            Datum d = SubrUtils.nextIf((Iterator<Datum>)itr, mesg, body);
            Datum k = SubrUtils.nextIf((Iterator<Datum>)itr, mesg, body);
            Datum f = SubrUtils.nextIf((Iterator<Datum>)itr, mesg, body);
            Datum th = Iterators.nextIf(itr, null);
            SubrUtils.checkTerminated(itr, body, mesg);
            this.checkType(d, mesg);
            SubrUtils.checkType(f, Procedure.class, mesg, "err.require.procedure");
            try {
                Datum y;
                Datum x = ((LispMap)((Object)d)).get(k);
                if (x != null) {
                    y = Scheme.callva(f, env, mesg, x);
                } else if (th == null) {
                    y = LispBoolean.FALSE;
                } else if (th instanceof Procedure) {
                    y = Scheme.callva(th, env, mesg, new Datum[0]);
                } else {
                    throw mesg.getError("err.require.procedure", th);
                }
                Datum[] r = ((LispMap)((Object)d)).copyPut(k, y);
                return r[0];
            }
            catch (ClassCastException e) {
                throw mesg.getError(e.getMessage(), k);
            }
        }
    }

    public static class MapUpdateS
    extends Subr {
        private Class<?> tocheck;
        private String errcd;

        public MapUpdateS(Class<?> cls, String err) {
            this.tocheck = cls;
            this.errcd = err;
        }

        private void checkType(Datum c1a, LispMessage mesg) {
            SubrUtils.checkType(c1a, this.tocheck, mesg, this.errcd);
        }

        @Override
        public Datum eval(Datum body, Environment env, LispMessage mesg) {
            ConsIterator itr = new ConsIterator(body);
            Datum d = SubrUtils.nextIf((Iterator<Datum>)itr, mesg, body);
            Datum k = SubrUtils.nextIf((Iterator<Datum>)itr, mesg, body);
            Datum f = SubrUtils.nextIf((Iterator<Datum>)itr, mesg, body);
            Datum th = Iterators.nextIf(itr, null);
            SubrUtils.checkTerminated(itr, body, mesg);
            this.checkType(d, mesg);
            SubrUtils.checkType(f, Procedure.class, mesg, "err.require.procedure");
            try {
                Datum y;
                Datum x = ((LispMap)((Object)d)).get(k);
                if (x != null) {
                    y = Scheme.callva(f, env, mesg, x);
                } else if (th == null) {
                    y = LispBoolean.FALSE;
                } else if (th instanceof Procedure) {
                    y = Scheme.callva(th, env, mesg, new Datum[0]);
                } else {
                    throw mesg.getError("err.require.procedure", th);
                }
                Datum[] r = ((LispMap)((Object)d)).put(k, y);
                return r[0];
            }
            catch (ClassCastException e) {
                throw mesg.getError(e.getMessage(), k);
            }
            catch (ImmutableException e) {
                throw mesg.getError("err.srfi44.immutable", d);
            }
        }
    }
}

