/*
 * Decompiled with CFR 0.152.
 */
package net.morilib.lisp.collection;

import java.util.Iterator;
import net.morilib.lisp.ConsIterator;
import net.morilib.lisp.Datum;
import net.morilib.lisp.Environment;
import net.morilib.lisp.LispBoolean;
import net.morilib.lisp.LispInteger;
import net.morilib.lisp.LispMessage;
import net.morilib.lisp.Procedure;
import net.morilib.lisp.Scheme;
import net.morilib.lisp.Subr;
import net.morilib.lisp.accessor.ILispRef;
import net.morilib.lisp.collection.ImmutableException;
import net.morilib.lisp.collection.LispBag;
import net.morilib.lisp.subr.SubrUtils;
import net.morilib.lisp.subr.TernaryArgs;
import net.morilib.lisp.subr.UnaryArgs;
import net.morilib.util.Iterators;

public interface LispSequence
extends LispBag,
ILispRef {
    public Datum get(int var1);

    public Datum first();

    public Datum last();

    public Datum copySet(int var1, Datum var2);

    public Datum set(int var1, Datum var2) throws ImmutableException;

    public Datum replace(LispSequence var1, int var2, int var3, int var4);

    public Datum arraycopy(LispSequence var1, int var2, int var3, int var4) throws ImmutableException;

    public Datum copy(int var1, int var2);

    public static class IsSequence
    extends UnaryArgs {
        @Override
        protected Datum execute(Datum c1a, Environment env, LispMessage mesg) {
            return LispBoolean.getInstance(c1a instanceof LispSequence);
        }
    }

    public static class SequenceCopy
    extends Subr {
        private Class<?> tocheck;
        private String errcd;

        public SequenceCopy(Class<?> cls, String err) {
            this.tocheck = cls;
            this.errcd = err;
        }

        private void checkType(Datum c1a, LispMessage mesg) {
            SubrUtils.checkType(c1a, this.tocheck, mesg, this.errcd);
        }

        @Override
        public Datum eval(Datum body, Environment env, LispMessage mesg) {
            ConsIterator itr = new ConsIterator(body);
            Datum dd = SubrUtils.nextIf((Iterator<Datum>)itr, mesg, body);
            this.checkType(dd, mesg);
            LispSequence d = (LispSequence)((Object)dd);
            if (!itr.hasNext()) {
                return d.duplicate();
            }
            int b = SubrUtils.nextSmallInt((Iterator<Datum>)itr, 0, mesg);
            int e = SubrUtils.nextSmallInt((Iterator<Datum>)itr, d.size(), mesg);
            SubrUtils.checkTerminated(itr, body, mesg);
            try {
                if (e < b) {
                    throw mesg.getError("err.range.invalid");
                }
                return d.copy(b, e);
            }
            catch (IndexOutOfBoundsException f) {
                throw mesg.getError("err.srfi44.outofbounds", f.getMessage());
            }
        }
    }

    public static class SequenceGetLeft
    extends Subr {
        private Class<?> tocheck;
        private String errcd;

        public SequenceGetLeft(Class<?> cls, String err) {
            this.tocheck = cls;
            this.errcd = err;
        }

        private void checkType(Datum c1a, LispMessage mesg) {
            SubrUtils.checkType(c1a, this.tocheck, mesg, this.errcd);
        }

        @Override
        public Datum eval(Datum body, Environment env, LispMessage mesg) {
            ConsIterator itr = new ConsIterator(body);
            Datum d = SubrUtils.nextIf((Iterator<Datum>)itr, mesg, body);
            Datum th = Iterators.nextIf(itr, null);
            this.checkType(d, mesg);
            if (th != null && !(th instanceof Procedure)) {
                throw mesg.getError("err.require.procedure", th);
            }
            LispSequence c = (LispSequence)((Object)d);
            if (c.size() > 0) {
                return c.first();
            }
            if (th == null) {
                return LispBoolean.FALSE;
            }
            return Scheme.callva(th, env, mesg, new Datum[0]);
        }
    }

    public static class SequenceGetRight
    extends Subr {
        private Class<?> tocheck;
        private String errcd;

        public SequenceGetRight(Class<?> cls, String err) {
            this.tocheck = cls;
            this.errcd = err;
        }

        private void checkType(Datum c1a, LispMessage mesg) {
            SubrUtils.checkType(c1a, this.tocheck, mesg, this.errcd);
        }

        @Override
        public Datum eval(Datum body, Environment env, LispMessage mesg) {
            ConsIterator itr = new ConsIterator(body);
            Datum d = SubrUtils.nextIf((Iterator<Datum>)itr, mesg, body);
            Datum th = Iterators.nextIf(itr, null);
            this.checkType(d, mesg);
            if (th != null && !(th instanceof Procedure)) {
                throw mesg.getError("err.require.procedure", th);
            }
            LispSequence c = (LispSequence)((Object)d);
            if (c.size() > 0) {
                return c.last();
            }
            if (c.size() < 0) {
                throw mesg.getError("err.srfi44.infinite", d);
            }
            if (th == null) {
                return LispBoolean.FALSE;
            }
            return Scheme.callva(th, env, mesg, new Datum[0]);
        }
    }

    public static class SequenceRef
    extends Subr {
        private Class<?> tocheck;
        private String errcd;

        public SequenceRef(Class<?> cls, String err) {
            this.tocheck = cls;
            this.errcd = err;
        }

        private void checkType(Datum c1a, LispMessage mesg) {
            SubrUtils.checkType(c1a, this.tocheck, mesg, this.errcd);
        }

        @Override
        public Datum eval(Datum body, Environment env, LispMessage mesg) {
            ConsIterator itr = new ConsIterator(body);
            Datum d = SubrUtils.nextIf((Iterator<Datum>)itr, mesg, body);
            int i = SubrUtils.nextSmallInt((Iterator<Datum>)itr, mesg, body);
            Datum th = Iterators.nextIf(itr, null);
            this.checkType(d, mesg);
            SubrUtils.checkTerminated(itr, body, mesg);
            if (th != null && !(th instanceof Procedure)) {
                throw mesg.getError("err.require.procedure", th);
            }
            try {
                return ((LispSequence)((Object)d)).get(i);
            }
            catch (IndexOutOfBoundsException e) {
                if (th == null) {
                    throw mesg.getError("err.srfi44.outofbounds", LispInteger.valueOf(i));
                }
                return Scheme.callva(th, env, mesg, new Datum[0]);
            }
        }
    }

    public static class SequenceReplaceFrom
    extends Subr {
        private Class<?> tocheck;
        private String errcd;

        public SequenceReplaceFrom(Class<?> cls, String err) {
            this.tocheck = cls;
            this.errcd = err;
        }

        private void checkType(Datum c1a, LispMessage mesg) {
            SubrUtils.checkType(c1a, this.tocheck, mesg, this.errcd);
        }

        @Override
        public Datum eval(Datum body, Environment env, LispMessage mesg) {
            ConsIterator itr = new ConsIterator(body);
            Datum dd = SubrUtils.nextIf((Iterator<Datum>)itr, mesg, body);
            int bd = SubrUtils.nextSmallInt((Iterator<Datum>)itr, mesg, body);
            Datum ss = SubrUtils.nextIf((Iterator<Datum>)itr, mesg, body);
            this.checkType(dd, mesg);
            if (!(ss instanceof LispSequence)) {
                throw mesg.getError("err.srfi44.require.sequence", ss);
            }
            LispSequence d = (LispSequence)((Object)dd);
            LispSequence s = (LispSequence)((Object)ss);
            int bs = SubrUtils.nextSmallInt((Iterator<Datum>)itr, 0, mesg);
            int es = SubrUtils.nextSmallInt((Iterator<Datum>)itr, s.size(), mesg);
            SubrUtils.checkTerminated(itr, body, mesg);
            try {
                return d.replace(s, bs, bd, es - bs);
            }
            catch (IndexOutOfBoundsException e) {
                throw mesg.getError("err.srfi44.outofbounds", e.getMessage());
            }
            catch (ClassCastException e) {
                throw mesg.getError(e.getMessage(), ss);
            }
        }
    }

    public static class SequenceReplaceFromS
    extends Subr {
        private Class<?> tocheck;
        private String errcd;

        public SequenceReplaceFromS(Class<?> cls, String err) {
            this.tocheck = cls;
            this.errcd = err;
        }

        private void checkType(Datum c1a, LispMessage mesg) {
            SubrUtils.checkType(c1a, this.tocheck, mesg, this.errcd);
        }

        @Override
        public Datum eval(Datum body, Environment env, LispMessage mesg) {
            ConsIterator itr = new ConsIterator(body);
            Datum dd = SubrUtils.nextIf((Iterator<Datum>)itr, mesg, body);
            int bd = SubrUtils.nextSmallInt((Iterator<Datum>)itr, mesg, body);
            Datum ss = SubrUtils.nextIf((Iterator<Datum>)itr, mesg, body);
            this.checkType(dd, mesg);
            if (!(ss instanceof LispSequence)) {
                throw mesg.getError("err.srfi44.require.sequence", ss);
            }
            LispSequence d = (LispSequence)((Object)dd);
            LispSequence s = (LispSequence)((Object)ss);
            int bs = SubrUtils.nextSmallInt((Iterator<Datum>)itr, 0, mesg);
            int es = SubrUtils.nextSmallInt((Iterator<Datum>)itr, s.size(), mesg);
            SubrUtils.checkTerminated(itr, body, mesg);
            try {
                return d.arraycopy(s, bs, bd, es - bs);
            }
            catch (IndexOutOfBoundsException e) {
                throw mesg.getError("err.srfi44.outofbounds", e.getMessage());
            }
            catch (ImmutableException e) {
                throw mesg.getError("err.srfi44.immutable", dd);
            }
            catch (UnsupportedOperationException e) {
                throw mesg.getError("err.srfi44.immutable", dd);
            }
            catch (ClassCastException e) {
                throw mesg.getError(e.getMessage(), ss);
            }
        }
    }

    public static class SequenceSet
    extends TernaryArgs {
        private Class<?> tocheck;
        private String errcd;

        public SequenceSet(Class<?> cls, String err) {
            this.tocheck = cls;
            this.errcd = err;
        }

        private void checkType(Datum c1a, LispMessage mesg) {
            SubrUtils.checkType(c1a, this.tocheck, mesg, this.errcd);
        }

        @Override
        protected Datum execute(Datum c1a, Datum c2a, Datum c3a, Environment env, LispMessage mesg) {
            int i = SubrUtils.getSmallInt(c2a, mesg);
            this.checkType(c1a, mesg);
            try {
                return ((LispSequence)((Object)c1a)).copySet(i, c3a);
            }
            catch (IndexOutOfBoundsException e) {
                throw mesg.getError("err.srfi44.outofbounds", LispInteger.valueOf(i));
            }
            catch (ClassCastException e) {
                throw mesg.getError(e.getMessage(), c3a);
            }
        }
    }

    public static class SequenceSetS
    extends TernaryArgs {
        private Class<?> tocheck;
        private String errcd;

        public SequenceSetS(Class<?> cls, String err) {
            this.tocheck = cls;
            this.errcd = err;
        }

        private void checkType(Datum c1a, LispMessage mesg) {
            SubrUtils.checkType(c1a, this.tocheck, mesg, this.errcd);
        }

        @Override
        protected Datum execute(Datum c1a, Datum c2a, Datum c3a, Environment env, LispMessage mesg) {
            int i = SubrUtils.getSmallInt(c2a, mesg);
            this.checkType(c1a, mesg);
            try {
                return ((LispSequence)((Object)c1a)).set(i, c3a);
            }
            catch (IndexOutOfBoundsException e) {
                throw mesg.getError("err.srfi44.outofbounds", LispInteger.valueOf(i));
            }
            catch (ImmutableException e) {
                throw mesg.getError("err.srfi44.immutable", c1a);
            }
            catch (UnsupportedOperationException e) {
                throw mesg.getError("err.srfi44.immutable", c1a);
            }
            catch (ClassCastException e) {
                throw mesg.getError(e.getMessage(), c3a);
            }
        }
    }
}

