/*
 * Decompiled with CFR 0.152.
 */
package net.morilib.lisp.file;

import java.io.File;
import java.io.IOException;
import java.util.Iterator;
import net.morilib.lisp.ConsIterator;
import net.morilib.lisp.Datum;
import net.morilib.lisp.Environment;
import net.morilib.lisp.LispBoolean;
import net.morilib.lisp.LispInteger;
import net.morilib.lisp.LispMessage;
import net.morilib.lisp.Subr;
import net.morilib.lisp.Symbol;
import net.morilib.lisp.file.LispFiles;
import net.morilib.lisp.subr.SubrUtils;
import net.morilib.util.io.Files;

public class Chmod
extends Subr {
    @Override
    public Datum eval(Datum body, Environment env, LispMessage mesg) {
        ConsIterator itr = new ConsIterator(body);
        Datum c2a = SubrUtils.nextIf((Iterator<Datum>)itr, mesg, body);
        boolean r = true;
        try {
            while (itr.hasNext()) {
                File f = LispFiles.getFile(env, itr.next(), mesg);
                if (c2a instanceof LispInteger) {
                    r &= Files.chmod(f, SubrUtils.getSmallInt(c2a, mesg));
                    continue;
                }
                if (c2a instanceof Symbol) {
                    r &= Files.chmod(f, SubrUtils.getSymbolName(c2a, mesg));
                    continue;
                }
                throw mesg.getError("err.file.require.chmod", c2a);
            }
            return LispBoolean.getInstance(r);
        }
        catch (IOException e) {
            throw mesg.getError("err.io", e.getMessage());
        }
        catch (IllegalArgumentException e) {
            throw mesg.getError("err.file.require.chmod", c2a);
        }
    }
}

