/*
 * Decompiled with CFR 0.152.
 */
package net.morilib.lisp.file;

import java.io.File;
import java.io.IOException;
import net.morilib.lisp.ConsIterator;
import net.morilib.lisp.Datum;
import net.morilib.lisp.Environment;
import net.morilib.lisp.LispMessage;
import net.morilib.lisp.Subr;
import net.morilib.lisp.Undef;
import net.morilib.lisp.file.LispFiles;
import net.morilib.lisp.subr.SubrUtils;

public class TouchFile
extends Subr {
    @Override
    public Datum eval(Datum body, Environment env, LispMessage mesg) {
        try {
            ConsIterator itr = new ConsIterator(body);
            while (itr.hasNext()) {
                File f = LispFiles.getFile(env, SubrUtils.getString(itr.next(), mesg));
                if (f.isFile()) {
                    f.setLastModified(System.currentTimeMillis());
                    continue;
                }
                if (f.exists()) continue;
                f.createNewFile();
            }
            SubrUtils.checkTerminated(itr, body, mesg);
            return Undef.UNDEF;
        }
        catch (IOException e) {
            throw mesg.getError("err.io", e.getMessage());
        }
    }
}

