/*
 * Decompiled with CFR 0.152.
 */
package net.morilib.lisp.iterator;

import java.io.Closeable;
import java.io.IOException;
import java.io.Reader;
import net.morilib.lisp.ConsListBuilder;
import net.morilib.lisp.Datum;
import net.morilib.lisp.Datum2;
import net.morilib.lisp.LispMessage;
import net.morilib.lisp.LispString;
import net.morilib.lisp.iterator.ILispIterator;
import net.morilib.parser.csv.CSVConfig;
import net.morilib.parser.csv.CSVException;
import net.morilib.parser.csv.StringCSVPullParser;

public class LispCSVIterator
extends Datum2
implements ILispIterator,
Closeable {
    private StringCSVPullParser parser;
    private Datum list;
    private LispMessage mesg;

    public LispCSVIterator(Reader rd, String delimiters, int quote, int comment, int newline, LispMessage mesg) {
        CSVConfig conf = new CSVConfig(delimiters, quote, false, comment, "", newline, comment > 0);
        this.parser = new StringCSVPullParser(rd, conf);
        this.read();
    }

    private void read() {
        ConsListBuilder bld = new ConsListBuilder();
        try {
            if (this.parser.next()) {
                String[] stringArray = this.parser.get();
                int n = stringArray.length;
                int n2 = 0;
                while (n2 < n) {
                    String s = stringArray[n2];
                    bld.append(new LispString(s));
                    ++n2;
                }
                this.list = bld.get();
            } else {
                this.list = null;
            }
        }
        catch (CSVException e) {
            try {
                this.close();
            }
            catch (IOException e1) {
                throw this.mesg.getError("err.io");
            }
            throw this.mesg.getError("err.iterator.csv.invalid");
        }
        catch (IOException e) {
            try {
                this.close();
            }
            catch (IOException e1) {
                throw this.mesg.getError("err.io");
            }
            throw this.mesg.getError("err.io");
        }
    }

    @Override
    public boolean isTerminated() {
        return this.list == null;
    }

    @Override
    public ILispIterator next() {
        this.read();
        return this;
    }

    @Override
    public Datum getCurrentDatum() {
        return this.list;
    }

    @Override
    public void close() throws IOException {
        this.parser.close();
        this.list = null;
    }

    @Override
    public void toDisplayString(StringBuilder buf) {
        buf.append("#<csv-iterator>");
    }
}

