/*
 * Decompiled with CFR 0.152.
 */
package net.morilib.lisp.iterator;

import net.morilib.lisp.Datum;
import net.morilib.lisp.Datum2;
import net.morilib.lisp.Environment;
import net.morilib.lisp.LispMessage;
import net.morilib.lisp.Nil;
import net.morilib.lisp.Procedure;
import net.morilib.lisp.Scheme;
import net.morilib.lisp.iterator.ILispIterator;

public class LispCustomIterator
extends Datum2
implements ILispIterator {
    private Procedure isnull;
    private Procedure car;
    private Procedure cdr;
    private Environment env;
    private LispMessage mesg;

    public LispCustomIterator(Procedure isnull, Procedure car, Procedure cdr, Environment env, LispMessage mesg) {
        this.isnull = isnull;
        this.car = car;
        this.cdr = cdr;
        this.env = env;
        this.mesg = mesg;
    }

    @Override
    public boolean isTerminated() {
        return Scheme.callva(this.isnull, this.env, this.mesg, new Datum[0]).isTrue();
    }

    @Override
    public ILispIterator next() {
        Datum d = Nil.NIL;
        try {
            d = Scheme.callva(this.cdr, this.env, this.mesg, new Datum[0]);
            return d;
        }
        catch (ClassCastException e) {
            throw this.mesg.getError("err.iterator.require.iterator", d);
        }
    }

    @Override
    public Datum getCurrentDatum() {
        return Scheme.callva(this.car, this.env, this.mesg, new Datum[0]);
    }

    @Override
    public void toDisplayString(StringBuilder buf) {
        buf.append("#<custom-iterator>");
    }
}

