/*
 * Decompiled with CFR 0.152.
 */
package net.morilib.lisp.lib.srfi013;

import java.util.List;
import net.morilib.lisp.ConsIterator;
import net.morilib.lisp.Datum;
import net.morilib.lisp.Environment;
import net.morilib.lisp.LispMessage;
import net.morilib.lisp.LispString;
import net.morilib.lisp.LispUtils;
import net.morilib.lisp.Subr;
import net.morilib.lisp.Symbol;
import net.morilib.lisp.subr.SubrUtils;

public class StringJoin
extends Subr {
    private static final Datum INFIX = Symbol.getSymbol("infix");
    private static final Datum STRICT_INFIX = Symbol.getSymbol("strict-infix");
    private static final Datum SUFFIX = Symbol.getSymbol("suffix");
    private static final Datum PREFIX = Symbol.getSymbol("prefix");

    @Override
    public Datum eval(Datum body, Environment env, LispMessage mesg) {
        List<Datum> l = LispUtils.consToList(body, mesg);
        String dlm = " ";
        Datum grm = INFIX;
        StringBuilder b = new StringBuilder();
        if (l.size() < 1 || l.size() > 3) {
            throw mesg.getError("err.argument", body);
        }
        if (l.size() == 2) {
            dlm = SubrUtils.getString(l.get(1), mesg);
        } else if (l.size() == 3) {
            dlm = SubrUtils.getString(l.get(1), mesg);
            grm = l.get(2);
        }
        ConsIterator itr = new ConsIterator(l.get(0));
        if (!itr.hasNext() && grm.equals(STRICT_INFIX)) {
            throw mesg.getError("err.require.list.notnull", l.get(0));
        }
        int i = 0;
        while (itr.hasNext()) {
            String s = SubrUtils.getString(itr.next(), mesg);
            if (grm.equals(SUFFIX)) {
                b.append(s).append(dlm);
            } else if (grm.equals(PREFIX)) {
                b.append(dlm).append(s);
            } else {
                if (!grm.equals(INFIX) && !grm.equals(STRICT_INFIX)) {
                    throw mesg.getError("err.symbol.invalid", grm);
                }
                if (i > 0) {
                    b.append(dlm).append(s);
                } else {
                    b.append(s);
                }
            }
            ++i;
        }
        return new LispString(b.toString());
    }
}

