/*
 * Decompiled with CFR 0.152.
 */
package net.morilib.lisp.lib.srfi094;

import java.math.BigInteger;
import net.morilib.lisp.Datum;
import net.morilib.lisp.Environment;
import net.morilib.lisp.LispInteger;
import net.morilib.lisp.LispMessage;
import net.morilib.lisp.subr.UnaryArgs;
import net.morilib.math.Math2;

public class IntegerSqrt
extends UnaryArgs {
    @Override
    protected Datum execute(Datum c1a, Environment env, LispMessage mesg) {
        if (c1a instanceof LispInteger) {
            BigInteger x = ((LispInteger)c1a).getBigInteger();
            if (x.signum() < 0) {
                throw mesg.getError("err.srfi94.outofdomain", c1a);
            }
            BigInteger r = Math2.sqrtExact(x);
            if (r.signum() < 0) {
                throw mesg.getError("err.srfi94.resultnotinteger");
            }
            return LispInteger.valueOf(r);
        }
        throw mesg.getError("err.require.int", c1a);
    }
}

