/*
 * Decompiled with CFR 0.152.
 */
package net.morilib.lisp.lib.ssql;

import java.sql.SQLException;
import java.util.Map;
import net.morilib.lisp.Cons;
import net.morilib.lisp.Datum;
import net.morilib.lisp.Environment;
import net.morilib.lisp.Keyword;
import net.morilib.lisp.LispMessage;
import net.morilib.lisp.LispUtils;
import net.morilib.lisp.Undef;
import net.morilib.lisp.sql.LispJdbcPrepared;
import net.morilib.lisp.sql.LispSQLException;
import net.morilib.lisp.subr.TernaryArgs;
import net.morilib.sql.util.DBMSDependentException;
import net.morilib.util.ArrayListStack;

public class PrepareSsql
extends TernaryArgs {
    @Override
    protected Datum execute(Datum c1a, Datum c2a, Datum c3a, Environment env, LispMessage mesg) {
        ArrayListStack<Datum> st = new ArrayListStack<Datum>();
        int no = 1;
        if (!(c1a instanceof LispJdbcPrepared)) {
            throw mesg.getError("err.jdbc.require.prepared", c1a);
        }
        LispJdbcPrepared pp = (LispJdbcPrepared)c1a;
        Map<Datum, Datum> mp = LispUtils.assocToMap(c3a);
        st.add(c2a);
        while (!st.isEmpty()) {
            Datum d2;
            Datum d1 = (Datum)st.pop();
            if (d1 instanceof Cons) {
                st.push(((Cons)d1).getCdr());
                st.push(((Cons)d1).getCar());
                continue;
            }
            if (!(d1 instanceof Keyword) || (d2 = mp.get(d1)) == null) continue;
            try {
                pp.setDatum(no++, d2);
            }
            catch (SQLException e) {
                throw LispSQLException.getError(mesg, e);
            }
            catch (DBMSDependentException e) {
                throw mesg.getError("err.jdbc.typemapping", d2);
            }
        }
        return Undef.UNDEF;
    }
}

