/*
 * Decompiled with CFR 0.152.
 */
package net.morilib.lisp.lingua.numeral;

import java.util.Iterator;
import net.morilib.lingua.numeral.LatinNumeral;
import net.morilib.lisp.ConsIterator;
import net.morilib.lisp.Datum;
import net.morilib.lisp.Environment;
import net.morilib.lisp.LispBoolean;
import net.morilib.lisp.LispMessage;
import net.morilib.lisp.LispString;
import net.morilib.lisp.Subr;
import net.morilib.lisp.subr.SubrUtils;
import net.morilib.util.Iterators;

public class NumberToLatinNumeral
extends Subr {
    @Override
    public Datum eval(Datum body, Environment env, LispMessage mesg) {
        ConsIterator itr = new ConsIterator(body);
        int v = SubrUtils.nextSmallInt((Iterator<Datum>)itr, mesg, body);
        String c = SubrUtils.nextSymbolName((Iterator<Datum>)itr, "nominative", mesg);
        String g = SubrUtils.nextSymbolName((Iterator<Datum>)itr, "neuter", mesg);
        Datum m = Iterators.nextIf(itr, LispBoolean.FALSE);
        SubrUtils.checkTerminated(itr, body, mesg);
        LatinNumeral.Case cs = c.equals("nominative") ? LatinNumeral.Case.NOMINATIVE : (c.equals("genitive") ? LatinNumeral.Case.GENITIVE : (c.equals("dative") ? LatinNumeral.Case.DATIVE : (c.equals("accusative") ? LatinNumeral.Case.ACCUSATIVE : (c.equals("ablative") ? LatinNumeral.Case.ABLATIVE : LatinNumeral.Case.NOMINATIVE))));
        LatinNumeral.Gender gn = g.equals("neuter") ? LatinNumeral.Gender.NEUTER : (g.equals("muscline") ? LatinNumeral.Gender.MUSCLINE : (g.equals("feminine") ? LatinNumeral.Gender.FEMININE : LatinNumeral.Gender.NEUTER));
        if (v <= 0) {
            throw mesg.getError("err.require.int.nonnegative");
        }
        String s = m.isTrue() ? LatinNumeral.toNumeralWithMacron(v, gn, cs) : LatinNumeral.toNumeral(v, gn, cs);
        return s == null ? LispBoolean.FALSE : new LispString(s);
    }
}

