/*
 * Decompiled with CFR 0.152.
 */
package net.morilib.lisp.math;

import java.util.Iterator;
import net.morilib.lisp.ConsIterator;
import net.morilib.lisp.Datum;
import net.morilib.lisp.Environment;
import net.morilib.lisp.LispInteger;
import net.morilib.lisp.LispMessage;
import net.morilib.lisp.Subr;
import net.morilib.lisp.subr.SubrUtils;
import net.morilib.math.Math2;
import net.morilib.util.primitive.IntegerArrayVector;

public class AntisymmetricEpsilon
extends Subr {
    @Override
    public Datum eval(Datum body, Environment env, LispMessage mesg) {
        ConsIterator itr = new ConsIterator(body);
        IntegerArrayVector v = new IntegerArrayVector();
        while (itr.hasNext()) {
            v.add(SubrUtils.nextSmallInt((Iterator<Datum>)itr, mesg, body));
        }
        SubrUtils.checkTerminated(itr, body, mesg);
        int[] a = v.toIntArray();
        int i = 0;
        while (i < a.length) {
            if (a[i] < 0 || a[i] > a.length) {
                throw mesg.getError("err.range.invalid", Integer.toString(a[i]));
            }
            int n = i++;
            a[n] = a[n] - 1;
        }
        return LispInteger.valueOf(Math2.permutationParity(a));
    }
}

