/*
 * Decompiled with CFR 0.152.
 */
package net.morilib.lisp.math;

import java.math.BigInteger;
import net.morilib.lisp.Datum;
import net.morilib.lisp.Environment;
import net.morilib.lisp.LispBoolean;
import net.morilib.lisp.LispDouble;
import net.morilib.lisp.LispInteger;
import net.morilib.lisp.LispMessage;
import net.morilib.lisp.LispReal;
import net.morilib.lisp.LispSmallInt;
import net.morilib.lisp.subr.BinaryArgs;
import net.morilib.lisp.subr.SubrUtils;
import net.morilib.math.Math2;

public class BinomialCoefficient
extends BinaryArgs {
    @Override
    protected Datum execute(Datum c1a, Datum c2a, Environment env, LispMessage mesg) {
        LispReal r = SubrUtils.getReal(c1a, mesg);
        int k = SubrUtils.getSmallInt(c2a, mesg);
        if (r instanceof LispSmallInt) {
            BigInteger b = Math2.binomialCoefficient(r.getInt(), k);
            return b != null ? LispInteger.valueOf(b) : LispBoolean.FALSE;
        }
        return new LispDouble(Math2.binomialCoefficient(r.doubleValue(), k));
    }
}

