/*
 * Decompiled with CFR 0.152.
 */
package net.morilib.lisp.math.angle;

import net.morilib.lisp.Datum2;
import net.morilib.lisp.LispDouble;
import net.morilib.lisp.LispInteger;
import net.morilib.lisp.LispMath;
import net.morilib.lisp.LispNumber;
import net.morilib.lisp.LispReal;
import net.morilib.lisp.math.angle.ILispAngle;
import net.morilib.lisp.math.angle.LispRadian;

public class LispAngleTrigonometric
extends Datum2
implements ILispAngle {
    private LispReal hypotenuse;
    private LispReal opposite;
    private LispReal adjacent;

    LispAngleTrigonometric(LispReal h, LispReal o, LispReal a) {
        if (h.signum() <= 0 || o.signum() <= 0 || a.signum() <= 0) {
            throw new IllegalArgumentException();
        }
        this.hypotenuse = h;
        this.opposite = o;
        this.adjacent = a;
    }

    public static ILispAngle sin(LispReal hyp, LispReal opp) {
        if (opp.signum() == 0) {
            return new LispRadian(LispInteger.ZERO);
        }
        if (!hyp.isExact() || !opp.isExact() || opp.signum() < 0) {
            return new LispRadian(Math.asin(opp.doubleValue() / hyp.doubleValue()));
        }
        return new LispAngleTrigonometric(hyp, opp, LispAngleTrigonometric.pyt1(hyp, opp));
    }

    public static ILispAngle cos(LispReal hyp, LispReal adj) {
        if (adj.signum() == 0) {
            return new LispRadian(LispRadian.RIGHT_ANGLE);
        }
        if (!hyp.isExact() || !adj.isExact() || adj.signum() < 0) {
            return new LispRadian(Math.acos(adj.doubleValue() / hyp.doubleValue()));
        }
        return new LispAngleTrigonometric(hyp, LispAngleTrigonometric.pyt1(hyp, adj), adj);
    }

    public static ILispAngle tan(LispReal adj, LispReal opp) {
        if (!adj.isExact() || !opp.isExact() || adj.signum() <= 0 || opp.signum() <= 0) {
            return new LispRadian(Math.atan2(opp.doubleValue(), adj.doubleValue()));
        }
        return new LispAngleTrigonometric(LispAngleTrigonometric.pyt2(adj, opp), opp, adj);
    }

    private static LispReal pyt1(LispReal hyp, LispReal x) {
        return LispMath.sqrt(((LispReal)hyp.power(2)).subtract((LispReal)x.power(2))).getReal();
    }

    private static LispReal pyt2(LispReal x, LispReal y) {
        return LispMath.sqrt(((LispReal)x.power(2)).add((LispReal)y.power(2))).getReal();
    }

    @Override
    public ILispAngle add(ILispAngle y) {
        return new LispRadian(this.byRadian()).add(y);
    }

    @Override
    public ILispAngle sub(ILispAngle y) {
        return new LispRadian(this.byRadian()).sub(y);
    }

    @Override
    public ILispAngle uminus() {
        return new LispRadian(this.byRadian()).uminus();
    }

    @Override
    public ILispAngle mul(LispNumber x) {
        return new LispRadian(this.byRadian()).mul(x);
    }

    @Override
    public LispReal byRadian() {
        return new LispDouble(Math.acos(this.cos().doubleValue()));
    }

    @Override
    public LispReal byDegree() {
        return new LispDouble(Math.acos(this.cos().doubleValue() / Math.PI * 180.0));
    }

    @Override
    public LispReal byGrade() {
        return new LispDouble(Math.acos(this.cos().doubleValue() / Math.PI * 200.0));
    }

    @Override
    public LispReal sin() {
        return this.opposite.divide(this.hypotenuse);
    }

    @Override
    public LispReal cos() {
        return this.adjacent.divide(this.hypotenuse);
    }

    @Override
    public LispReal tan() {
        return this.opposite.divide(this.adjacent);
    }

    @Override
    public LispReal cot() {
        return this.adjacent.divide(this.opposite);
    }

    @Override
    public LispReal sec() {
        return this.hypotenuse.divide(this.adjacent);
    }

    @Override
    public LispReal cosec() {
        return this.hypotenuse.divide(this.opposite);
    }

    @Override
    public boolean isAcute() {
        return true;
    }

    @Override
    public boolean isRight() {
        return false;
    }

    @Override
    public boolean isObtuse() {
        return false;
    }

    @Override
    public boolean isStraight() {
        return false;
    }

    @Override
    public boolean isReflex() {
        return false;
    }

    @Override
    public boolean isSinExact() {
        return this.hypotenuse.isExact() && this.opposite.isExact();
    }

    @Override
    public boolean isCosExact() {
        return this.hypotenuse.isExact() && this.adjacent.isExact();
    }

    @Override
    public boolean isTanExact() {
        return this.adjacent.isExact() && this.opposite.isExact();
    }

    @Override
    public boolean isExact() {
        return true;
    }

    @Override
    public ILispAngle toExact() {
        return this;
    }

    @Override
    public ILispAngle toInexact() {
        return new LispRadian(this.byRadian().doubleValue());
    }

    @Override
    public int compareTo(ILispAngle o) {
        if (!o.isAcute()) {
            return -1;
        }
        if (!(o instanceof LispAngleTrigonometric)) {
            return this.byRadian().compareTo(o.byRadian());
        }
        LispAngleTrigonometric t = (LispAngleTrigonometric)o;
        if (t.isSinExact() && this.isSinExact()) {
            return this.opposite.divide(this.hypotenuse).compareTo(t.opposite.divide(t.hypotenuse));
        }
        if (this.isCosExact() && t.isCosExact()) {
            return this.adjacent.divide(this.hypotenuse).compareTo(t.adjacent.divide(t.hypotenuse));
        }
        if (this.isTanExact() && t.isTanExact()) {
            return this.opposite.divide(this.adjacent).compareTo(t.opposite.divide(t.adjacent));
        }
        return this.byRadian().compareTo(o.byRadian());
    }

    @Override
    public boolean isEqualTo(ILispAngle x) {
        return this.compareTo(x) == 0;
    }

    @Override
    public void toDisplayString(StringBuilder buf) {
        if (this.isSinExact()) {
            buf.append("sin ");
            buf.append(this.opposite.divide(this.hypotenuse).print());
        } else if (this.isCosExact()) {
            buf.append("cos ");
            buf.append(this.adjacent.divide(this.hypotenuse).print());
        } else if (this.isTanExact()) {
            buf.append("tan ");
            buf.append(this.opposite.divide(this.adjacent).print());
        } else {
            buf.append("cos ");
            buf.append(this.opposite.divide(this.hypotenuse).print());
        }
    }
}

