/*
 * Decompiled with CFR 0.152.
 */
package net.morilib.lisp.math.angle;

import net.morilib.lisp.Datum2;
import net.morilib.lisp.LispDouble;
import net.morilib.lisp.LispInteger;
import net.morilib.lisp.LispNumber;
import net.morilib.lisp.LispReal;
import net.morilib.lisp.LispUtils;
import net.morilib.lisp.math.angle.ILispAngle;
import net.morilib.lisp.math.constants.LispPi;

public class LispRadian
extends Datum2
implements ILispAngle {
    static final LispReal RIGHT_ANGLE = LispPi.PI.divide(LispInteger.valueOf(2));
    static final LispReal STRAIGHT_ANGLE = LispPi.PI;
    static final LispReal FULL_ANGLE = LispPi.PI.multiply(2);
    private LispReal angle;

    public LispRadian(LispReal a) {
        this.angle = a.remainder(FULL_ANGLE);
    }

    public LispRadian(double a) {
        this.angle = new LispDouble(Math.IEEEremainder(a, Math.PI * 2));
    }

    @Override
    public ILispAngle add(ILispAngle y) {
        return new LispRadian(this.angle.add(y.byRadian()));
    }

    @Override
    public ILispAngle sub(ILispAngle y) {
        return new LispRadian(this.angle.subtract(y.byRadian()));
    }

    @Override
    public ILispAngle uminus() {
        return new LispRadian(this.angle.uminus());
    }

    @Override
    public ILispAngle mul(LispNumber x) {
        if (x instanceof LispReal) {
            return new LispRadian(this.angle.multiply((LispReal)x));
        }
        throw new IllegalArgumentException();
    }

    @Override
    public LispReal byRadian() {
        return this.angle;
    }

    @Override
    public LispReal byDegree() {
        return (LispReal)this.angle.divide(LispPi.PI).multiply(180);
    }

    @Override
    public LispReal byGrade() {
        return (LispReal)this.angle.divide(LispPi.PI).multiply(200);
    }

    @Override
    public LispReal sin() {
        return new LispDouble(Math.sin(this.angle.doubleValue()));
    }

    @Override
    public LispReal cos() {
        return new LispDouble(Math.cos(this.angle.doubleValue()));
    }

    @Override
    public LispReal tan() {
        return new LispDouble(Math.tan(this.angle.doubleValue()));
    }

    @Override
    public LispReal cot() {
        return new LispDouble(1.0 / Math.tan(this.angle.doubleValue()));
    }

    @Override
    public LispReal sec() {
        return new LispDouble(1.0 / Math.cos(this.angle.doubleValue()));
    }

    @Override
    public LispReal cosec() {
        return new LispDouble(1.0 / Math.sin(this.angle.doubleValue()));
    }

    @Override
    public boolean isAcute() {
        return this.angle.compareTo(RIGHT_ANGLE) < 0;
    }

    @Override
    public boolean isRight() {
        return this.angle.isEqualTo(RIGHT_ANGLE);
    }

    @Override
    public boolean isObtuse() {
        return this.angle.compareTo(RIGHT_ANGLE) > 0 && this.angle.compareTo(STRAIGHT_ANGLE) < 0;
    }

    @Override
    public boolean isStraight() {
        return this.angle.isEqualTo(STRAIGHT_ANGLE);
    }

    @Override
    public boolean isReflex() {
        return this.angle.compareTo(STRAIGHT_ANGLE) > 0;
    }

    @Override
    public int compareTo(ILispAngle o) {
        return this.angle.compareTo(o.byRadian());
    }

    @Override
    public boolean isSinExact() {
        return false;
    }

    @Override
    public boolean isCosExact() {
        return false;
    }

    @Override
    public boolean isTanExact() {
        return false;
    }

    @Override
    public boolean isExact() {
        return this.angle.isExact();
    }

    @Override
    public ILispAngle toExact() {
        return new LispRadian(this.angle.toExact());
    }

    @Override
    public ILispAngle toInexact() {
        return new LispRadian(this.angle.toInexact());
    }

    @Override
    public boolean isEqualTo(ILispAngle x) {
        return this.angle.isEqualTo(x.byRadian());
    }

    public int hashCode() {
        return this.angle.hashCode();
    }

    public boolean equals(Object o) {
        if (o instanceof ILispAngle) {
            return this.angle.isEqualTo(((ILispAngle)o).byRadian());
        }
        return false;
    }

    @Override
    public void toDisplayString(StringBuilder buf) {
        buf.append(LispUtils.print(this.angle)).append("#rad");
    }
}

