/*
 * Decompiled with CFR 0.152.
 */
package net.morilib.lisp.math.constants;

import java.math.BigInteger;
import net.morilib.lang.number.Integer2;
import net.morilib.lang.number.Rational;
import net.morilib.lisp.LispAlternatingSeriesNumber;
import net.morilib.lisp.LispComplex;
import net.morilib.lisp.LispDouble;
import net.morilib.lisp.LispExactReal;
import net.morilib.lisp.LispInteger;
import net.morilib.lisp.LispNumber;
import net.morilib.lisp.LispRational;
import net.morilib.math.constants.SqrtNumber;

public class LispSqrt
extends LispAlternatingSeriesNumber {
    public static final LispSqrt GOLDEN_NUMBER = new LispSqrt(Rational.valueOf(5), Rational.valueOf(1, 2), Rational.valueOf(1, 2));
    public static final LispSqrt SILVER_NUMBER = new LispSqrt(Rational.valueOf(2), Rational.ONE, Rational.ONE);
    private Rational val;
    private Rational _scale;
    private Rational _shift;

    LispSqrt(Rational x, Rational scale, Rational shift) {
        super(new SqrtNumber(x, scale, shift));
        this.val = x;
        this._scale = scale;
        this._shift = shift;
    }

    public static LispComplex valueOf(Rational x, Rational scale, Rational shift) {
        if (scale.isZero() || x.isZero()) {
            return LispRational.valueOf(shift);
        }
        if (x.signum() < 0) {
            return LispComplex.newComplex(LispInteger.ZERO, new LispDouble(Math.sqrt(-x.doubleValue())));
        }
        return new LispSqrt(x, scale, shift);
    }

    public static LispComplex valueOf(BigInteger b, Rational scale, Rational shift) {
        return LispSqrt.valueOf(Rational.valueOf(Integer2.valueOf(b), Integer2.ONE), scale, shift);
    }

    @Override
    public LispExactReal prototype(Rational scale, Rational shift) {
        return (LispExactReal)LispSqrt.valueOf(this.val, scale, shift);
    }

    @Override
    public LispExactReal uminus() {
        return new LispSqrt(this.val, this._scale.negate(), this._shift.negate());
    }

    @Override
    public LispNumber add(LispNumber x) {
        if (!(x instanceof LispSqrt)) {
            return super.add(x);
        }
        LispSqrt q = (LispSqrt)x;
        if (this.val.equals(q.val)) {
            return LispSqrt.valueOf(this.val, this._scale.add(q._scale), this._shift.add(this._shift));
        }
        return new LispDouble(this.doubleValue() + q.doubleValue());
    }

    @Override
    public LispNumber sub(LispNumber x) {
        if (!(x instanceof LispSqrt)) {
            return super.sub(x);
        }
        LispSqrt q = (LispSqrt)x;
        if (this.val.equals(q.val)) {
            return LispSqrt.valueOf(this.val, this._scale.subtract(q._scale), this._shift.subtract(this._shift));
        }
        return new LispDouble(this.doubleValue() - q.doubleValue());
    }

    @Override
    public LispNumber mul(LispNumber x) {
        if (!(x instanceof LispSqrt)) {
            return super.mul(x);
        }
        LispSqrt q = (LispSqrt)x;
        if (this.val.equals(q.val)) {
            return LispSqrt.valueOf(this.val, this._scale.multiply(q._shift).add(this._shift.multiply(q._scale)), this._scale.multiply(q._scale).multiply(this.val).add(this._shift.multiply(q._shift)));
        }
        return new LispDouble(this.doubleValue() * q.doubleValue());
    }

    @Override
    public LispNumber div(LispNumber x) {
        if (!(x instanceof LispSqrt)) {
            return super.div(x);
        }
        LispSqrt q = (LispSqrt)x;
        if (this.val.equals(q.val)) {
            Rational d = q._scale.multiply(q._scale).multiply(this.val).subtract(q._shift.multiply(q._shift));
            Rational p = q._shift.negate();
            return LispSqrt.valueOf(this.val, this._scale.multiply(p).add(this._shift.multiply(q._scale)).divide(d), this._scale.multiply(q._scale).multiply(this.val).add(this._shift.multiply(p)).divide(d));
        }
        return new LispDouble(this.doubleValue() / q.doubleValue());
    }

    @Override
    public boolean isFinite() {
        return true;
    }
}

