/*
 * Decompiled with CFR 0.152.
 */
package net.morilib.lisp.math.polynomial;

import net.morilib.lisp.Symbol;
import net.morilib.lisp.math.LispNumberField;
import net.morilib.lisp.math.polynomial.LispExact1Function;
import net.morilib.lisp.math.polynomial.LispRationalFunction1;
import net.morilib.math.functions.ListPolynomial1Coefficients;
import net.morilib.math.functions.Polynomial1Coefficients;
import net.morilib.math.functions.RationalFunction1Coefficients;

public class LispPolynomial1
extends LispExact1Function {
    private Polynomial1Coefficients<LispNumberField> poly;

    public LispPolynomial1(Polynomial1Coefficients<LispNumberField> poly, Symbol symbol) {
        super(symbol);
        this.poly = poly;
    }

    public LispPolynomial1(LispNumberField number, Symbol symbol) {
        super(symbol);
        this.poly = new ListPolynomial1Coefficients<LispNumberField>(number);
    }

    public Polynomial1Coefficients<LispNumberField> getPoly() {
        return this.poly;
    }

    public Symbol getSymbol() {
        return this.symbol;
    }

    @Override
    public boolean isUnit() {
        return this.poly.isUnit();
    }

    @Override
    public boolean isZero() {
        return this.poly.isZero();
    }

    @Override
    public LispExact1Function negate() {
        return new LispPolynomial1((Polynomial1Coefficients<LispNumberField>)this.poly.negate(), this.symbol);
    }

    @Override
    public LispExact1Function subtract(LispExact1Function x) {
        if (!this.symbol.equals(x.symbol)) {
            throw new IllegalArgumentException();
        }
        if (x instanceof LispPolynomial1) {
            return new LispPolynomial1(this.poly.subtract(((LispPolynomial1)x).poly), this.symbol);
        }
        if (x instanceof LispRationalFunction1) {
            return LispExact1Function.toRational(this).subtract(x);
        }
        throw new IllegalArgumentException();
    }

    @Override
    public LispExact1Function add(LispExact1Function x) {
        if (!this.symbol.equals(x.symbol)) {
            throw new IllegalArgumentException();
        }
        if (x instanceof LispPolynomial1) {
            return new LispPolynomial1(this.poly.add(((LispPolynomial1)x).poly), this.symbol);
        }
        if (x instanceof LispRationalFunction1) {
            return LispExact1Function.toRational(this).add(x);
        }
        throw new IllegalArgumentException();
    }

    @Override
    public LispExact1Function multiply(int n) {
        return new LispPolynomial1((Polynomial1Coefficients<LispNumberField>)this.poly.multiply(n), this.symbol);
    }

    @Override
    public LispExact1Function multiply(LispExact1Function x) {
        if (!this.symbol.equals(x.symbol)) {
            throw new IllegalArgumentException();
        }
        if (x instanceof LispPolynomial1) {
            return new LispPolynomial1(this.poly.multiply((LispNumberField)((Object)((LispPolynomial1)x).poly)), this.symbol);
        }
        if (x instanceof LispRationalFunction1) {
            return LispExact1Function.toRational(this).multiply(x);
        }
        throw new IllegalArgumentException();
    }

    @Override
    public LispExact1Function power(int n) {
        return new LispPolynomial1((Polynomial1Coefficients<LispNumberField>)this.poly.power(n), this.symbol);
    }

    @Override
    public LispExact1Function invert() {
        ListPolynomial1Coefficients<LispNumberField> l1 = new ListPolynomial1Coefficients<LispNumberField>(LispNumberField.ONE);
        RationalFunction1Coefficients<LispNumberField> r1 = RationalFunction1Coefficients.valueOf(l1, this.poly);
        return new LispRationalFunction1(r1, this.symbol);
    }

    @Override
    public LispExact1Function divide(LispExact1Function x) {
        if (!this.symbol.equals(x.symbol)) {
            throw new IllegalArgumentException();
        }
        if (x instanceof LispPolynomial1) {
            return new LispPolynomial1(this.poly.divide(((LispPolynomial1)x).poly), this.symbol);
        }
        if (x instanceof LispRationalFunction1) {
            return LispExact1Function.toRational(this).divide(x);
        }
        throw new IllegalArgumentException();
    }

    public int hashCode() {
        int r = 17;
        r = 37 * (r + this.symbol.hashCode());
        r = 37 * (r + this.poly.hashCode());
        return r;
    }

    public boolean equals(Object obj) {
        if (obj instanceof LispPolynomial1) {
            LispPolynomial1 p = (LispPolynomial1)obj;
            return this.symbol.equals(p.symbol) && this.poly.equals(p.poly);
        }
        return false;
    }

    @Override
    public String toString() {
        return this.poly.toString(this.symbol.getName());
    }
}

