/*
 * Decompiled with CFR 0.152.
 */
package net.morilib.lisp.math.polynomial1;

import java.util.Iterator;
import net.morilib.lisp.ConsIterator;
import net.morilib.lisp.ConsListBuilder;
import net.morilib.lisp.Datum;
import net.morilib.lisp.Environment;
import net.morilib.lisp.LispBoolean;
import net.morilib.lisp.LispComplex;
import net.morilib.lisp.LispMessage;
import net.morilib.lisp.Subr;
import net.morilib.lisp.math.polynomial1.ILispPolynomial1;
import net.morilib.lisp.subr.SubrUtils;
import net.morilib.math.polynomial1.DoublePolynomial1;
import net.morilib.math.polynomial1.Polynomial1Utils;

public class SolvePolynomial1ByBairstow
extends Subr {
    @Override
    public Datum eval(Datum body, Environment env, LispMessage mesg) {
        ConsIterator itr = new ConsIterator(body);
        Datum c1a = SubrUtils.nextIf((Iterator<Datum>)itr, mesg, body);
        double epsilon = SubrUtils.nextDouble(itr, 1.0E-5);
        int iterate = SubrUtils.nextSmallInt((Iterator<Datum>)itr, 1000, mesg);
        SubrUtils.checkTerminated(itr, body, mesg);
        if (!(c1a instanceof ILispPolynomial1)) {
            throw mesg.getError("err.math.require.poly1", c1a);
        }
        ILispPolynomial1 p = (ILispPolynomial1)((Object)c1a);
        if (p.degree() >= 1) {
            double[] cef = new double[((ILispPolynomial1)((Object)c1a)).degree() + 1];
            int i = 0;
            while (i <= p.degree()) {
                cef[i] = SubrUtils.getDouble(p.coefficient(i), mesg);
                ++i;
            }
            DoublePolynomial1 dp = new DoublePolynomial1(cef);
            double[][] rs = Polynomial1Utils.solveByBairstow1(dp, epsilon, iterate);
            if (rs == null) {
                return LispBoolean.FALSE;
            }
            ConsListBuilder b = new ConsListBuilder();
            double[][] dArray = rs;
            int n = rs.length;
            int n2 = 0;
            while (n2 < n) {
                double[] d = dArray[n2];
                b.append(LispComplex.newComplex(d[0], d[1]));
                ++n2;
            }
            return b.get();
        }
        return LispBoolean.FALSE;
    }
}

