/*
 * Decompiled with CFR 0.152.
 */
package net.morilib.lisp.math.random;

import java.math.BigInteger;
import net.morilib.lisp.Datum;
import net.morilib.lisp.LispInteger;
import net.morilib.lisp.LispMessage;
import net.morilib.lisp.LispSmallInt;
import net.morilib.lisp.math.random.ILispRandomSource;
import net.morilib.lisp.math.random.LispMTRandomSource;
import net.morilib.lisp.subr.SubrUtils;
import net.morilib.math.random.MersenneTwisterRandom;

public class RandomSourceUtils {
    private static final BigInteger VAL = BigInteger.valueOf(0x100000000L);
    public static final ILispRandomSource DEFAULT = new LispMTRandomSource(MersenneTwisterRandom.getInstance());

    static Datum nextInt(ILispRandomSource src, Datum d, LispMessage mesg) {
        if (d instanceof LispSmallInt) {
            int n = SubrUtils.getSmallInt(d, mesg);
            return LispInteger.valueOf(src.getRandomSource().nextUnsignedInt() % (long)n);
        }
        if (d instanceof LispInteger) {
            BigInteger n = d.getBigInteger();
            BigInteger v = BigInteger.ZERO;
            BigInteger r = BigInteger.ZERO;
            while (n.compareTo(v) < 0) {
                long l = src.getRandomSource().nextUnsignedInt();
                r = r.multiply(VAL).add(BigInteger.valueOf(l));
                v = v.multiply(VAL);
            }
            return LispInteger.valueOf(r.remainder(n));
        }
        throw mesg.getError("err.require.int", d);
    }
}

