/*
 * Decompiled with CFR 0.152.
 */
package net.morilib.lisp.math.sequence;

import net.morilib.lisp.LispDouble;
import net.morilib.lisp.LispInteger;
import net.morilib.lisp.LispReal;
import net.morilib.lisp.math.sequence.AbstractLispRealSequence;
import net.morilib.lisp.math.sequence.ILispSequence;
import net.morilib.lisp.math.sequence.LispArithmeticSequence;

public class LispHarmonicSequence
extends AbstractLispRealSequence {
    public static final int INFINITE = -1;
    private LispReal a1;
    private LispReal d;
    private int size;

    public LispHarmonicSequence(LispReal a1, LispReal d, int size) {
        if (a1 == null || d == null) {
            throw new NullPointerException();
        }
        if (((LispReal)d.negate().invert()).isInteger()) {
            throw new IllegalArgumentException();
        }
        this.a1 = a1;
        this.d = d;
        this.size = size;
    }

    @Override
    public LispReal get(int i) {
        if (i < 1) {
            throw new IndexOutOfBoundsException();
        }
        return this.a1.divide(((LispReal)this.d.multiply(i - 1)).add(LispInteger.ONE));
    }

    @Override
    public LispReal limit() {
        return LispInteger.ZERO;
    }

    @Override
    public boolean isFinite() {
        return this.size >= 1;
    }

    @Override
    public int size() {
        return this.size;
    }

    @Override
    public ILispSequence inv() {
        return new LispArithmeticSequence((LispReal)this.a1.invert(), this.d.divide(this.a1), this.size);
    }

    @Override
    public LispReal sum() {
        if (this.size >= 1) {
            return this.sum(1, this.size());
        }
        if (this.d.signum() > 0) {
            return LispDouble.POSITIVE_INFINITY;
        }
        return LispDouble.NEGATIVE_INFINITY;
    }
}

