/*
 * Decompiled with CFR 0.152.
 */
package net.morilib.lisp.math.stat.test;

import net.morilib.lisp.ConsIterator;
import net.morilib.lisp.Datum;
import net.morilib.lisp.Environment;
import net.morilib.lisp.LispBoolean;
import net.morilib.lisp.LispMessage;
import net.morilib.lisp.subr.QuaternaryArgs;
import net.morilib.lisp.subr.SubrUtils;
import net.morilib.math.stat.StatisticsUtils;
import net.morilib.math.stat.dist.continuous.TDistribution;
import net.morilib.util.primitive.DoubleArrayVector;
import net.morilib.util.primitive.DoubleVector;

public class IsTestT2Sample
extends QuaternaryArgs {
    private void todouble(ConsIterator itr, DoubleVector v, LispMessage mesg) {
        while (itr.hasNext()) {
            v.addDouble(SubrUtils.getDouble(itr.next(), mesg));
        }
    }

    @Override
    protected Datum execute(Datum c1a, Datum c4a, Datum c5a, Datum c6a, Environment env, LispMessage mesg) {
        double max;
        double min;
        String type = SubrUtils.getSymbolName(c5a, mesg);
        double sign = SubrUtils.getDouble(c6a, mesg);
        DoubleArrayVector obs = new DoubleArrayVector();
        DoubleArrayVector ob2 = new DoubleArrayVector();
        this.todouble(new ConsIterator(c1a), obs, mesg);
        this.todouble(new ConsIterator(c4a), ob2, mesg);
        double[] obsv = obs.toDoubleArray();
        double[] ob2v = ob2.toDoubleArray();
        int num = obs.size();
        int num2 = ob2.size();
        double mean = StatisticsUtils.mean(obsv);
        double var = StatisticsUtils.variance(obsv);
        double mn2 = StatisticsUtils.mean(ob2v);
        double var2 = StatisticsUtils.variance(ob2v);
        double sv1 = var / (double)num;
        double sv2 = var2 / (double)num2;
        double t = (mean - mn2) / Math.sqrt(sv1 + sv2);
        double df = (sv1 + sv2) * (sv1 + sv2) / (sv1 * sv1 / (double)(num - 1) + sv2 * sv2 / (double)(num2 - 1));
        TDistribution tdis = new TDistribution(df);
        if (type.equals(">")) {
            min = Double.NEGATIVE_INFINITY;
            max = -tdis.invCdf(sign);
        } else if (type.equals("<")) {
            min = tdis.invCdf(sign);
            max = Double.POSITIVE_INFINITY;
        } else {
            min = tdis.invCdf(sign / 2.0);
            max = -min;
        }
        return LispBoolean.getInstance(min < t && t < max);
    }
}

