/*
 * Decompiled with CFR 0.152.
 */
package net.morilib.lisp.net.dhcp;

import java.io.IOException;
import java.net.InetAddress;
import java.util.Iterator;
import net.morilib.lisp.ConsIterator;
import net.morilib.lisp.Datum;
import net.morilib.lisp.Environment;
import net.morilib.lisp.LispBoolean;
import net.morilib.lisp.LispMessage;
import net.morilib.lisp.LispString;
import net.morilib.lisp.MultiValues;
import net.morilib.lisp.Subr;
import net.morilib.lisp.net.LispHardwareAddress;
import net.morilib.lisp.net.LispInetAddress;
import net.morilib.lisp.net.SubrNetUtils;
import net.morilib.lisp.subr.SubrUtils;
import net.morilib.lisp.uvector.LispU8Vector;
import net.morilib.net.dhcp.BOOTP;
import net.morilib.net.dhcp.BOOTPResult;

public class GetIpAddressByBootp
extends Subr {
    @Override
    public Datum eval(Datum body, Environment env, LispMessage mesg) {
        ConsIterator itr = new ConsIterator(body);
        try {
            byte[] hwaddr;
            InetAddress adr = SubrNetUtils.nextAddress(itr, body, mesg);
            InetAddress cad = SubrNetUtils.nextAddress(itr, body, mesg);
            Datum d1 = SubrUtils.nextIf((Iterator<Datum>)itr, mesg, body);
            int sec = SubrUtils.nextSmallInt((Iterator<Datum>)itr, 0, mesg);
            if (d1 instanceof LispHardwareAddress) {
                hwaddr = ((LispHardwareAddress)d1).getAddress();
            } else if (d1 instanceof LispU8Vector) {
                hwaddr = ((LispU8Vector)d1).toArray();
            } else {
                return LispBoolean.FALSE;
            }
            if (cad.getAddress().length != 4) {
                return LispBoolean.FALSE;
            }
            if (hwaddr.length != 6) {
                return LispBoolean.FALSE;
            }
            sec = sec > Short.MAX_VALUE ? Short.MAX_VALUE : sec;
            BOOTPResult res = BOOTP.request(adr, cad, hwaddr, (short)sec);
            return MultiValues.newValues(new LispInetAddress(res.getMyAddress()), new LispInetAddress(res.getServerAddress()), new LispString(res.getBootFilePath()));
        }
        catch (IOException e) {
            throw mesg.getError("err.io", e.getMessage());
        }
    }
}

