/*
 * Decompiled with CFR 0.152.
 */
package net.morilib.lisp.net.http;

import java.io.IOException;
import java.io.InputStreamReader;
import java.net.HttpURLConnection;
import java.util.Iterator;
import net.morilib.lisp.ConsIterator;
import net.morilib.lisp.Datum;
import net.morilib.lisp.Environment;
import net.morilib.lisp.InputPort;
import net.morilib.lisp.LispMessage;
import net.morilib.lisp.Subr;
import net.morilib.lisp.net.http.LispHttpConnection;
import net.morilib.lisp.subr.SubrUtils;
import net.morilib.util.Iterators;

public class HttpInputPort
extends Subr {
    @Override
    public Datum eval(Datum body, Environment env, LispMessage mesg) {
        ConsIterator itr = new ConsIterator(body);
        Datum c1a = SubrUtils.nextIf((Iterator<Datum>)itr, mesg, body);
        Datum c2a = Iterators.nextIf(itr);
        try {
            InputStreamReader rd;
            SubrUtils.checkTerminated(itr, body, mesg);
            if (!(c1a instanceof LispHttpConnection)) {
                throw mesg.getError("err.net.require.httpconnection", c1a);
            }
            if (c2a == null) {
                HttpURLConnection con = ((LispHttpConnection)c1a).connection;
                rd = new InputStreamReader(con.getInputStream());
            } else {
                HttpURLConnection con = ((LispHttpConnection)c1a).connection;
                rd = new InputStreamReader(con.getInputStream(), SubrUtils.getString(c2a, mesg));
            }
            return new InputPort(rd, mesg);
        }
        catch (IOException e) {
            throw mesg.getError("err.io");
        }
    }
}

