/*
 * Decompiled with CFR 0.152.
 */
package net.morilib.lisp.net.snmp;

import java.io.IOException;
import java.net.InetAddress;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import net.morilib.lisp.Cons;
import net.morilib.lisp.ConsIterator;
import net.morilib.lisp.ConsListBuilder;
import net.morilib.lisp.Datum;
import net.morilib.lisp.Environment;
import net.morilib.lisp.LispBoolean;
import net.morilib.lisp.LispInteger;
import net.morilib.lisp.LispMessage;
import net.morilib.lisp.LispSmallInt;
import net.morilib.lisp.LispString;
import net.morilib.lisp.LispUtils;
import net.morilib.lisp.MultiValues;
import net.morilib.lisp.Subr;
import net.morilib.lisp.datetime.LispDate;
import net.morilib.lisp.net.SubrNetUtils;
import net.morilib.lisp.net.snmp.LispOID;
import net.morilib.lisp.net.snmp.LispTimeTicks;
import net.morilib.lisp.subr.SubrUtils;
import net.morilib.net.snmp.ASN1Exception;
import net.morilib.net.snmp.ObjectIdentifier;
import net.morilib.net.snmp.SNMP;
import net.morilib.net.snmp.SNMPPDU;
import net.morilib.net.snmp.TimeTicks;
import net.morilib.util.Tuple2;

public class SnmpGet
extends Subr {
    private static Datum asn1todtm(Object a) {
        if (a == null) {
            return LispBoolean.FALSE;
        }
        if (a instanceof ObjectIdentifier) {
            return new LispOID((ObjectIdentifier)a);
        }
        if (a instanceof Date) {
            return new LispDate((Date)a);
        }
        if (a instanceof TimeTicks) {
            return new LispTimeTicks(((TimeTicks)a).toMilliseconds());
        }
        if (a instanceof Collection) {
            ConsListBuilder b = new ConsListBuilder();
            for (Object o : (Collection)a) {
                b.append(SnmpGet.asn1todtm(o));
            }
            return b.get();
        }
        return LispUtils.toDatum(a);
    }

    static Datum tupletodtm(Tuple2<ObjectIdentifier, Object> t) {
        return new Cons(SnmpGet.asn1todtm(t.getA()), SnmpGet.asn1todtm(t.getB()));
    }

    private static Datum parseVariables(List<Tuple2<ObjectIdentifier, Object>> variables) {
        ConsListBuilder b = new ConsListBuilder();
        for (Tuple2<ObjectIdentifier, Object> t : variables) {
            b.append(SnmpGet.tupletodtm(t));
        }
        return b.get();
    }

    static Datum parse(SNMPPDU req) {
        ArrayList<Datum> b = new ArrayList<Datum>();
        b.add(LispInteger.valueOf(req.getVersion() + 1));
        b.add(new LispString(req.getCommunity()));
        b.add(LispInteger.valueOf(req.getId()));
        b.add(LispInteger.valueOf(req.getErrorCode()));
        b.add(LispInteger.valueOf(req.getErrorIndex()));
        b.add(SnmpGet.parseVariables(req.getVariables()));
        return MultiValues.newValues(b);
    }

    @Override
    public Datum eval(Datum body, Environment env, LispMessage mesg) {
        ConsIterator itr = new ConsIterator(body);
        Datum d1 = SubrUtils.nextIf((Iterator<Datum>)itr, mesg, body);
        Datum d2 = SubrUtils.nextIf((Iterator<Datum>)itr, mesg, body);
        int port = 161;
        try {
            String comm;
            InetAddress addr = SubrNetUtils.getAddress(d1, mesg);
            if (d2 instanceof LispSmallInt) {
                port = SubrUtils.getSmallInt(d2, mesg);
                comm = SubrUtils.nextString((Iterator<Datum>)itr, mesg, body);
            } else {
                comm = SubrUtils.getString(d2, mesg);
            }
            Datum d3 = SubrUtils.nextIf((Iterator<Datum>)itr, mesg, body);
            SubrUtils.checkTerminated(itr, body, mesg);
            if (!(d3 instanceof LispOID)) {
                throw mesg.getError("err.net.require.oid", d3);
            }
            ObjectIdentifier oid = ((LispOID)d3).oid;
            return SnmpGet.parse(SNMP.getRequest(addr, port, comm, oid));
        }
        catch (IOException e) {
            throw mesg.getError("err.io", e.getMessage());
        }
        catch (ASN1Exception e) {
            throw mesg.getError("err.net.asn1.invalid");
        }
    }
}

