/*
 * Decompiled with CFR 0.152.
 */
package net.morilib.lisp.net.snmp;

import java.io.IOException;
import java.net.InetAddress;
import java.util.Iterator;
import net.morilib.lisp.ConsIterator;
import net.morilib.lisp.ConsListBuilder;
import net.morilib.lisp.Datum;
import net.morilib.lisp.Environment;
import net.morilib.lisp.LispMessage;
import net.morilib.lisp.LispSmallInt;
import net.morilib.lisp.Subr;
import net.morilib.lisp.net.SubrNetUtils;
import net.morilib.lisp.net.snmp.LispOID;
import net.morilib.lisp.net.snmp.SnmpGet;
import net.morilib.lisp.subr.SubrUtils;
import net.morilib.net.snmp.ASN1Exception;
import net.morilib.net.snmp.ObjectIdentifier;
import net.morilib.net.snmp.SNMP;
import net.morilib.net.snmp.SNMPPDU;

public class SnmpWalk
extends Subr {
    @Override
    public Datum eval(Datum body, Environment env, LispMessage mesg) {
        ConsIterator itr = new ConsIterator(body);
        Datum d1 = SubrUtils.nextIf((Iterator<Datum>)itr, mesg, body);
        Datum d2 = SubrUtils.nextIf((Iterator<Datum>)itr, mesg, body);
        int port = 161;
        try {
            ObjectIdentifier oid2;
            String comm;
            InetAddress addr = SubrNetUtils.getAddress(d1, mesg);
            if (d2 instanceof LispSmallInt) {
                port = SubrUtils.getSmallInt(d2, mesg);
                comm = SubrUtils.nextString((Iterator<Datum>)itr, mesg, body);
            } else {
                comm = SubrUtils.getString(d2, mesg);
            }
            Datum d3 = SubrUtils.nextIf((Iterator<Datum>)itr, mesg, body);
            SubrUtils.checkTerminated(itr, body, mesg);
            if (!(d3 instanceof LispOID)) {
                throw mesg.getError("err.net.require.oid", d3);
            }
            ObjectIdentifier oid = oid2 = ((LispOID)d3).oid;
            ConsListBuilder b = new ConsListBuilder();
            while (true) {
                SNMPPDU pdu;
                if ((pdu = SNMP.getNext(addr, port, comm, oid2)).getErrorCode() != 0) {
                    return b.get();
                }
                if (pdu.getVariables().isEmpty()) {
                    return b.get();
                }
                if (!pdu.getVariables().get(0).getA().isSubTreeOf(oid)) break;
                b.append(SnmpGet.tupletodtm(pdu.getVariables().get(0)));
                oid2 = pdu.getVariables().get(0).getA();
            }
            return b.get();
        }
        catch (IOException e) {
            throw mesg.getError("err.io", e.getMessage());
        }
        catch (ASN1Exception e) {
            throw mesg.getError("err.net.asn1.invalid");
        }
    }
}

