/*
 * Decompiled with CFR 0.152.
 */
package net.morilib.lisp.nio;

import java.math.BigInteger;
import java.nio.BufferUnderflowException;
import java.util.Iterator;
import net.morilib.lisp.ConsIterator;
import net.morilib.lisp.Datum;
import net.morilib.lisp.Environment;
import net.morilib.lisp.LispInteger;
import net.morilib.lisp.LispMessage;
import net.morilib.lisp.SRFI74Endianness;
import net.morilib.lisp.Subr;
import net.morilib.lisp.Undef;
import net.morilib.lisp.nio.LispBlob;
import net.morilib.lisp.subr.SubrUtils;

public class BlobUintSetS
extends Subr {
    @Override
    public Datum eval(Datum body, Environment env, LispMessage mesg) {
        ConsIterator itr = new ConsIterator(body);
        int s = SubrUtils.nextSmallInt((Iterator<Datum>)itr, mesg, body);
        Datum e = SubrUtils.nextIf((Iterator<Datum>)itr, mesg, body);
        Datum b = SubrUtils.nextIf((Iterator<Datum>)itr, mesg, body);
        int k = SubrUtils.nextSmallInt((Iterator<Datum>)itr, mesg, body);
        Datum z = SubrUtils.nextIf((Iterator<Datum>)itr, mesg, body);
        SubrUtils.checkTerminated(itr, body, mesg);
        if (!(e instanceof SRFI74Endianness.Endian)) {
            throw mesg.getError("err.srfi74.require.endianness", e);
        }
        if (!(b instanceof LispBlob)) {
            throw mesg.getError("err.srfi74.require.blob", b);
        }
        if (!(z instanceof LispInteger)) {
            throw mesg.getError("err.require.int", z);
        }
        BigInteger x = z.getBigInteger();
        BigInteger max = BigInteger.ONE.shiftLeft(s * 8);
        try {
            if (x.compareTo(max) >= 0 || x.signum() < 0) {
                throw mesg.getError("err.srfi74.value.outofrange", z);
            }
            ((LispBlob)b).putUnsigned(s, k, x);
            return Undef.UNDEF;
        }
        catch (BufferUnderflowException f) {
            throw mesg.getError("err.srfi74.blob.outofrange", "" + k);
        }
        catch (IllegalArgumentException f) {
            throw mesg.getError("err.srfi74.index.invalid", "" + k);
        }
    }
}

