/*
 * Decompiled with CFR 0.152.
 */
package net.morilib.lisp.painter;

import java.awt.image.RenderedImage;
import java.io.File;
import java.io.IOException;
import java.util.List;
import javax.imageio.ImageIO;
import net.morilib.lisp.Datum;
import net.morilib.lisp.Environment;
import net.morilib.lisp.LispIOException;
import net.morilib.lisp.LispMessage;
import net.morilib.lisp.LispString;
import net.morilib.lisp.LispUtils;
import net.morilib.lisp.OutputPort;
import net.morilib.lisp.Subr;
import net.morilib.lisp.Symbol;
import net.morilib.lisp.Undef;
import net.morilib.lisp.painter.SchlushPainterFrame;

public class WriteImageFile
extends Subr {
    @Override
    public Datum eval(Datum body, Environment env, LispMessage mesg) {
        String imgf;
        List<Datum> l = LispUtils.consToList(body, mesg);
        String fname = null;
        OutputPort outp = null;
        if (l.size() == 2) {
            if (!(l.get(0) instanceof SchlushPainterFrame)) {
                throw mesg.getError("err.require.painterframe", l.get(0));
            }
        } else if (l.size() == 3) {
            if (!(l.get(0) instanceof SchlushPainterFrame)) {
                throw mesg.getError("err.require.painterframe", l.get(0));
            }
            LispUtils.checkSymbol(l.get(2), mesg);
        }
        if (l.get(1) instanceof LispString) {
            fname = ((LispString)l.get(1)).getString();
        } else if (l.get(1) instanceof OutputPort) {
            outp = (OutputPort)l.get(1);
        } else {
            throw mesg.getError("err.image.require.filenameoroport", l.get(1));
        }
        if (l.size() == 3) {
            imgf = ((Symbol)l.get(2)).getName();
        } else if (fname != null) {
            int ind = fname.lastIndexOf(46);
            if (ind < 0) {
                throw mesg.getError("err.invaild.formatname", "");
            }
            imgf = fname.substring(ind + 1);
        } else {
            throw mesg.getError("err.invaild.formatname");
        }
        try {
            boolean r = fname != null ? ImageIO.write((RenderedImage)((SchlushPainterFrame)l.get((int)0)).image, imgf, new File(fname)) : ImageIO.write((RenderedImage)((SchlushPainterFrame)l.get((int)0)).image, imgf, outp.getPrintStream());
            if (!r) {
                throw mesg.getError("err.invalid.formatname", imgf);
            }
        }
        catch (IOException e) {
            throw new LispIOException(e);
        }
        return Undef.UNDEF;
    }
}

