/*
 * Decompiled with CFR 0.152.
 */
package net.morilib.lisp.painter.drawer;

import java.awt.Graphics;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import net.morilib.lisp.painter.drawer.CoordinateMap;
import net.morilib.lisp.painter.drawer.Drawer;

public class CompositeDrawer
implements Drawer {
    protected List<Drawer> drawers;

    public CompositeDrawer(Collection<Drawer> drawers) {
        this.drawers = new ArrayList<Drawer>(drawers);
    }

    public CompositeDrawer(Drawer ... drawers) {
        this(Arrays.asList(drawers));
    }

    public synchronized void add(Drawer drawer) {
        this.drawers.add(drawer);
    }

    public synchronized void clear() {
        this.drawers.clear();
    }

    public synchronized void undo() {
        this.drawers.remove(this.drawers.size() - 1);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void draw(Graphics g, int framex, int framey, CoordinateMap coordinate) {
        CompositeDrawer compositeDrawer = this;
        synchronized (compositeDrawer) {
            for (Drawer d : this.drawers) {
                d.draw(g, framex, framey, coordinate);
            }
        }
    }
}

