/*
 * Decompiled with CFR 0.152.
 */
package net.morilib.lisp.r6rs.io;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import net.morilib.lisp.Datum;
import net.morilib.lisp.Environment;
import net.morilib.lisp.LispMessage;
import net.morilib.lisp.LispString;
import net.morilib.lisp.r6rs.io.transcd.ILispTranscoder;
import net.morilib.lisp.r6rs.io.transcd.InputTranscoder;
import net.morilib.lisp.r6rs.io.transcd.StringOutputTranscoder;
import net.morilib.lisp.r6rs.io.transcd.Transcoders;
import net.morilib.lisp.subr.BinaryArgs;
import net.morilib.lisp.uvector.ILispBytevector;

public class BytevectorToString
extends BinaryArgs {
    @Override
    protected Datum execute(Datum c1a, Datum c2a, Environment env, LispMessage mesg) {
        if (!(c1a instanceof ILispBytevector)) {
            throw mesg.getError("err.uvector.require.8", c1a);
        }
        if (!(c2a instanceof ILispTranscoder)) {
            throw mesg.getError("err.io.require.transcoder", c2a);
        }
        try {
            ByteArrayInputStream ins = new ByteArrayInputStream(((ILispBytevector)((Object)c1a)).toBytes());
            InputTranscoder tri = ((ILispTranscoder)((Object)c2a)).newInput(ins);
            StringOutputTranscoder tro = new StringOutputTranscoder();
            Transcoders.copyWithClose(tri, tro);
            return new LispString(tro.toString());
        }
        catch (IOException e) {
            throw mesg.getError("err.io", e.getMessage());
        }
    }
}

