/*
 * Decompiled with CFR 0.152.
 */
package net.morilib.lisp.r6rs.io;

import java.io.BufferedInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import net.morilib.lisp.Datum;
import net.morilib.lisp.Datum2;
import net.morilib.lisp.LispNotSupportedException;
import net.morilib.lisp.r6rs.io.ILispBinaryInputPort;
import net.morilib.lisp.r6rs.io.transcd.ILispTranscoder;
import net.morilib.util.io.LookaheadInputStream;

public class LispInputStreamPort
extends Datum2
implements ILispBinaryInputPort {
    private LookaheadInputStream ins;

    public LispInputStreamPort(InputStream ins) {
        this.ins = new LookaheadInputStream(new BufferedInputStream(ins));
    }

    @Override
    public void close() throws IOException {
        this.ins.close();
    }

    @Override
    public int getByte() throws IOException {
        return this.ins.read();
    }

    @Override
    public int lookaheadByte() throws IOException {
        return this.ins.lookahead();
    }

    @Override
    public byte[] getBytes(int n) throws IOException {
        byte[] b = new byte[n];
        int l = this.ins.read(b);
        if (l < 0) {
            return null;
        }
        if (l < b.length) {
            byte[] r = new byte[l];
            System.arraycopy(b, 0, r, 0, l);
            return r;
        }
        return b;
    }

    @Override
    public int getBytes(byte[] buf, int start, int end) throws IOException {
        return this.ins.read(buf, start, end - start);
    }

    @Override
    public byte[] getBytesSome() throws IOException {
        return this.getBytes(1024);
    }

    @Override
    public byte[] getBytesAll() throws IOException {
        int l;
        ByteArrayOutputStream b = new ByteArrayOutputStream();
        byte[] c = new byte[1024];
        while ((l = this.ins.read(c)) >= 0) {
            b.write(c, 0, l);
        }
        byte[] r = b.toByteArray();
        return r.length == 0 ? null : r;
    }

    @Override
    public ILispTranscoder getTranscoder() {
        return null;
    }

    @Override
    public InputStream getInputStream() {
        return this.ins;
    }

    @Override
    public boolean isPortEof() throws IOException {
        return this.ins.lookahead() < 0;
    }

    @Override
    public boolean hasPortPosition() {
        return false;
    }

    @Override
    public Datum getPortPosition() {
        throw new LispNotSupportedException();
    }

    @Override
    public boolean hasSetPortPosition() {
        return false;
    }

    @Override
    public void setPortPosition(Datum pos) {
        throw new LispNotSupportedException();
    }

    @Override
    public void toDisplayString(StringBuilder buf) {
        buf.append("#<binary-port>");
    }
}

