/*
 * Decompiled with CFR 0.152.
 */
package net.morilib.lisp.r6rs.io;

import java.io.IOException;
import net.morilib.lisp.Datum;
import net.morilib.lisp.Datum2;
import net.morilib.lisp.LispNotSupportedException;
import net.morilib.lisp.LispUtils;
import net.morilib.lisp.r6rs.io.ILispTextualOutputPort;
import net.morilib.lisp.r6rs.io.transcd.ILispTranscoder;
import net.morilib.lisp.r6rs.io.transcd.LispBufferMode;
import net.morilib.lisp.r6rs.io.transcd.OutputTranscoder;

public class LispTextualOutputPort
extends Datum2
implements ILispTextualOutputPort {
    private ILispTranscoder tf;
    private OutputTranscoder tr;
    private LispBufferMode bm;

    public LispTextualOutputPort(OutputTranscoder tr, ILispTranscoder tf, LispBufferMode bm) {
        this.tf = tf;
        this.tr = tr;
        this.bm = bm;
    }

    @Override
    public void close() throws IOException {
        this.tr.close();
    }

    @Override
    public void putChar(int c) throws IOException {
        this.tr.write(c);
    }

    @Override
    public void putString(String s) throws IOException {
        this.tr.write(s);
    }

    @Override
    public void putString(String s, int start) throws IOException {
        this.tr.write(s, start, s.length() - start);
    }

    @Override
    public void putString(String s, int start, int end) throws IOException {
        this.tr.write(s, start, end - start);
    }

    @Override
    public void putDatum(Datum d) throws IOException {
        this.tr.write(LispUtils.print(d));
    }

    @Override
    public ILispTranscoder getTranscoder() {
        return this.tf;
    }

    @Override
    public boolean hasPortPosition() {
        return false;
    }

    @Override
    public Datum getPortPosition() {
        throw new LispNotSupportedException();
    }

    @Override
    public boolean hasSetPortPosition() {
        return false;
    }

    @Override
    public void setPortPosition(Datum pos) {
        throw new LispNotSupportedException();
    }

    @Override
    public void flush() throws IOException {
        this.tr.flush();
    }

    @Override
    public LispBufferMode getBufferMode() {
        return this.bm;
    }

    @Override
    public void toDisplayString(StringBuilder buf) {
        buf.append("#<textual-output-port>");
    }
}

