/*
 * Decompiled with CFR 0.152.
 */
package net.morilib.lisp.r6rs.io;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import net.morilib.lisp.ConsIterator;
import net.morilib.lisp.Datum;
import net.morilib.lisp.Environment;
import net.morilib.lisp.LispBoolean;
import net.morilib.lisp.LispMessage;
import net.morilib.lisp.MultiValues;
import net.morilib.lisp.Subr;
import net.morilib.lisp.r6rs.io.LispByteArrayBinaryOutputPort;
import net.morilib.lisp.r6rs.io.transcd.ILispTranscoder;
import net.morilib.lisp.subr.NoArgs;
import net.morilib.lisp.subr.SubrUtils;
import net.morilib.lisp.uvector.LispU8Vector;
import net.morilib.util.Iterators;

public class OpenBytevectorOutputPort
extends Subr {
    @Override
    public Datum eval(Datum body, Environment env, LispMessage mesg) {
        ConsIterator itr = new ConsIterator(body);
        Datum tr = Iterators.nextIf(itr, LispBoolean.FALSE);
        SubrUtils.checkTerminated(itr, body, mesg);
        if (tr.isTrue() && !(tr instanceof ILispTranscoder)) {
            throw mesg.getError("err.io.require.transcoder", tr);
        }
        if (tr.isTrue()) {
            try {
                final ByteArrayOutputStream ous = new ByteArrayOutputStream();
                Datum r1 = (Datum)((Object)((ILispTranscoder)((Object)tr)).newOutput(ous));
                NoArgs r2 = new NoArgs("extract bytevector"){

                    @Override
                    protected Datum execute(Environment env, LispMessage mesg) {
                        return new LispU8Vector(ous.toByteArray());
                    }
                };
                return MultiValues.newValues(r1, r2);
            }
            catch (IOException e) {
                throw mesg.getError("err.io", e.getMessage());
            }
        }
        final LispByteArrayBinaryOutputPort bop = new LispByteArrayBinaryOutputPort();
        NoArgs r2 = new NoArgs("extract bytevector"){

            @Override
            protected Datum execute(Environment env, LispMessage mesg) {
                return new LispU8Vector(bop.toByteArray());
            }
        };
        return MultiValues.newValues(bop, r2);
    }
}

