/*
 * Decompiled with CFR 0.152.
 */
package net.morilib.lisp.r6rs.io;

import java.io.IOException;
import net.morilib.lisp.Datum;
import net.morilib.lisp.Environment;
import net.morilib.lisp.LispMessage;
import net.morilib.lisp.r6rs.io.ILispBinaryInputPort;
import net.morilib.lisp.r6rs.io.ILispBinaryOutputPort;
import net.morilib.lisp.r6rs.io.LispTextualInputPort;
import net.morilib.lisp.r6rs.io.LispTextualOutputPort;
import net.morilib.lisp.r6rs.io.transcd.ILispTranscoder;
import net.morilib.lisp.r6rs.io.transcd.InputTranscoder;
import net.morilib.lisp.r6rs.io.transcd.OutputTranscoder;
import net.morilib.lisp.subr.BinaryArgs;

public class TranscodedPort
extends BinaryArgs {
    @Override
    protected Datum execute(Datum c1a, Datum c2a, Environment env, LispMessage mesg) {
        try {
            if (!(c2a instanceof ILispTranscoder)) {
                throw mesg.getError("err.io.require.transcoder", c2a);
            }
            if (c1a instanceof ILispBinaryInputPort) {
                InputTranscoder tr = ((ILispTranscoder)((Object)c2a)).newInput(((ILispBinaryInputPort)((Object)c1a)).getInputStream());
                return new LispTextualInputPort(tr, (ILispTranscoder)((Object)c2a));
            }
            if (c1a instanceof ILispBinaryOutputPort) {
                OutputTranscoder tr = ((ILispTranscoder)((Object)c2a)).newOutput(((ILispBinaryOutputPort)((Object)c1a)).getOutputStream());
                return new LispTextualOutputPort(tr, (ILispTranscoder)((Object)c2a), ((ILispBinaryOutputPort)((Object)c1a)).getBufferMode());
            }
            throw mesg.getError("err.io.require.port.binary", c1a);
        }
        catch (IOException e) {
            throw mesg.getError("err.io", e.getMessage());
        }
    }
}

