/*
 * Decompiled with CFR 0.152.
 */
package net.morilib.lisp.r6rs.io.transcd;

import java.io.IOException;
import net.morilib.lisp.Datum2;
import net.morilib.util.io.TranscodeException;

public abstract class LispErrorHandlingMode
extends Datum2 {
    public static final int MODE_IGNORE = 0;
    public static final int MODE_REPLACE = 1;
    public static final int MODE_RAISE = 2;
    public static final LispErrorHandlingMode IGNORE = new LispErrorHandlingMode(0){

        @Override
        public int ifRead(int code, int replace) throws IOException {
            return -1;
        }

        @Override
        public int ifWrite(int code, int replace) throws IOException {
            return -1;
        }
    };
    public static final LispErrorHandlingMode REPLACE = new LispErrorHandlingMode(1){

        @Override
        public int ifRead(int code, int replace) throws IOException {
            return replace;
        }

        @Override
        public int ifWrite(int code, int replace) throws IOException {
            return replace;
        }
    };
    public static final LispErrorHandlingMode RAISE = new LispErrorHandlingMode(2){

        @Override
        public int ifRead(int code, int replace) throws IOException {
            throw new TranscodeException("Invalid code:" + Integer.toHexString(code));
        }

        @Override
        public int ifWrite(int code, int replace) throws IOException {
            throw new TranscodeException("Invalid code:" + Integer.toHexString(code));
        }
    };
    private int mode;

    LispErrorHandlingMode(int mode) {
        this.mode = mode;
    }

    public int getMode() {
        return this.mode;
    }

    public abstract int ifRead(int var1, int var2) throws IOException;

    public abstract int ifWrite(int var1, int var2) throws IOException;

    @Override
    public void toDisplayString(StringBuilder buf) {
        buf.append("#<error-handling-mode ");
        switch (this.mode) {
            case 0: {
                buf.append("ignore>");
                break;
            }
            case 1: {
                buf.append("replace>");
                break;
            }
            case 2: {
                buf.append("raise>");
                break;
            }
            default: {
                buf.append("unknown>");
            }
        }
    }
}

