/*
 * Decompiled with CFR 0.152.
 */
package net.morilib.lisp.r6rs.record;

import java.util.Set;
import net.morilib.lisp.Datum;
import net.morilib.lisp.Environment;
import net.morilib.lisp.LispMessage;
import net.morilib.lisp.r6rs.record.R6RSRecord;
import net.morilib.lisp.r6rs.record.RecordTypeDescriptor;
import net.morilib.lisp.subr.BinaryArgs;
import net.morilib.lisp.subr.SubrUtils;
import net.morilib.lisp.subr.UnaryArgs;
import net.morilib.util.Iterators;

public class RecordAccessor
extends BinaryArgs {
    @Override
    protected Datum execute(Datum c1a, Datum c2a, Environment env, LispMessage mesg) {
        int n = SubrUtils.getSmallInt(c2a, mesg);
        if (c1a instanceof RecordTypeDescriptor) {
            final RecordTypeDescriptor rtd = (RecordTypeDescriptor)((Object)c1a);
            Set<String> fld = rtd.getFieldNames();
            if (n < 0 || n >= fld.size()) {
                throw mesg.getError("err.r6rsrecord.field.outofrange", c2a);
            }
            final String rn = Iterators.get(fld, n);
            return new UnaryArgs("accessor " + rtd.getId()){

                @Override
                protected Datum execute(Datum x, Environment env, LispMessage mesg) {
                    if (!(x instanceof R6RSRecord)) {
                        throw mesg.getError("err.r6rsrecord.require.record", x);
                    }
                    if (!rtd.equals(((R6RSRecord)((Object)x)).getRtd())) {
                        throw mesg.getError("err.r6rsrecord.rtdmismatch");
                    }
                    return ((R6RSRecord)((Object)x)).getField(rn);
                }
            };
        }
        throw mesg.getError("err.r6rsrecord.require.rtd", c1a);
    }
}

