/*
 * Decompiled with CFR 0.152.
 */
package net.morilib.lisp.r6rs.subr;

import java.math.BigInteger;
import net.morilib.lisp.Datum;
import net.morilib.lisp.Environment;
import net.morilib.lisp.LispInteger;
import net.morilib.lisp.LispMessage;
import net.morilib.lisp.MultiValues;
import net.morilib.lisp.subr.UnaryArgs;
import net.morilib.math.Math2;

public class ExactIntegerSqrt
extends UnaryArgs {
    @Override
    protected Datum execute(Datum c1a, Environment env, LispMessage mesg) {
        if (c1a instanceof LispInteger) {
            BigInteger x = ((LispInteger)c1a).getBigInteger();
            if (x.signum() < 0) {
                throw mesg.getError("err.require.int.nonnegative", c1a);
            }
            BigInteger[] r = Math2.sqrtExact2(x);
            return MultiValues.newValues(LispInteger.valueOf(r[0]), LispInteger.valueOf(r[1]));
        }
        throw mesg.getError("err.require.int", c1a);
    }
}

