/*
 * Decompiled with CFR 0.152.
 */
package net.morilib.lisp.r6rs.subr;

import java.math.BigInteger;
import net.morilib.lisp.Datum;
import net.morilib.lisp.Environment;
import net.morilib.lisp.LispInteger;
import net.morilib.lisp.LispMessage;
import net.morilib.lisp.LispReal;
import net.morilib.lisp.subr.BinaryArgs;

public class Mod
extends BinaryArgs {
    /*
     * WARNING - void declaration
     * Enabled aggressive block sorting
     */
    @Override
    protected Datum execute(Datum c1a, Datum c2a, Environment env, LispMessage mesg) {
        if (c1a instanceof LispReal && c2a instanceof LispReal) {
            LispReal r1 = (LispReal)c1a;
            LispReal r2 = (LispReal)c2a;
            if (r2.signum() == 0) {
                throw mesg.getError("err.divbyzero");
            }
            if (r1.isInteger() && r2.isInteger()) {
                void var5_12;
                BigInteger b;
                BigInteger a = r1.getBigInteger();
                BigInteger[] x = a.divideAndRemainder(b = r2.getBigInteger());
                if (x[1].signum() != 0 && a.signum() < 0) {
                    x[1] = b.signum() > 0 ? x[1].add(b) : x[1].subtract(b);
                }
                LispInteger lispInteger = LispInteger.valueOf(x[1]);
                if (r1.isExact()) {
                    if (r2.isExact()) return var5_12;
                }
                LispReal lispReal = lispInteger.toInexact();
                return var5_12;
            }
            if (r1.isInteger()) throw mesg.getError("err.require.int", r2);
            throw mesg.getError("err.require.int", r1);
        }
        if (c1a instanceof LispReal) throw mesg.getError("err.require.real", c2a);
        throw mesg.getError("err.require.real", c1a);
    }
}

